<?php

namespace App\Http\Controllers\Dashboard;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

use App\Models\User;
use Illuminate\Support\Facades\Http;
use JWTAuth;
use PHPOpenSourceSaver\JWTAuth\Exceptions\JWTException;
use Illuminate\Support\Facades\Cookie;

class TemplatesController extends Controller
{
    public $page_title;
    public function __construct() {
        $this->page_title  = '';
    }
    private function getAuthorizationHeaders()
    {
        $token = Cookie::get('token');
        return [
            'Authorization' => 'Bearer '.$token,
            'Accept' => 'application/json',
        ];
    }

    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $base_url = env('APP_URL');
        
        $headers = $this->getAuthorizationHeaders();
        $users = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/dashboard');
        $category = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/category');
        $checklist = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/checklist_template');
        
        return view('pages.templates', ['page_title' => 'Templates'],compact('users','category','checklist'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $base_url = env('APP_URL');

        $name = $request->name;
        $password = "lensaudits";
        $role = "1";
        $permission = "1";
        $total_auditor_active = "0";
        $total_auditor_inactive = "0";
        $schedules_start_time = $request->schedules_start_time;
        $schedules_end_time = $request->schedules_end_time;
        

        $headers = $this->getAuthorizationHeaders();
        $response = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/create/department',[
            'name' => $name,
            'password' => $password,
            'role' => $role,
            'permission' => $permission,
            'total_auditor_active' => $total_auditor_active,
            'total_auditor_inactive' => $total_auditor_inactive,
            'schedules_start_time' => $schedules_start_time,
            'schedules_end_time' => $schedules_end_time,
        ]);
        

        $result = json_decode((string)$response->getBody(),true);
        // return dd($result);
        if($result['status'] == true){
            return redirect()->route('templates');
        }else{
            return redirect()->back();
        }

    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }
}
