<?php

namespace App\Http\Controllers\Dashboard;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

use Illuminate\Support\Facades\Http;
use JWTAuth;
use PHPOpenSourceSaver\JWTAuth\Exceptions\JWTException;
use Illuminate\Support\Facades\Cookie;

class SectionController extends Controller
{
    public $page_title;
    public function __construct() {
        $this->page_title  = '';
    }
    private function getAuthorizationHeaders()
    {
        $token = Cookie::get('token');
        return [
            'Authorization' => 'Bearer '.$token,
            'Accept' => 'application/json',
        ];
    }

    /**
     * Display a listing of the resource.
     */
    public function index(Request $request)
    {
        $base_url = env('APP_URL');

        $headers = $this->getAuthorizationHeaders();

        $checklist_id = $request->route('id');
        $users = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/section');

        // return dd($users);
        return view('pages.section.index', ['page_title' => 'Section Management'],compact('users','checklist_id'));
    }
    public function list(Request $request)
    {
        $base_url = env('APP_URL');

        $headers = $this->getAuthorizationHeaders();
        
        $checklist_id = $request->route('id');
        $users = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/section',[
            'checklist_id' => $checklist_id
        ]);

        $section_list = [
            'data' => $users['data']['section_list']
        ];

        return $section_list;
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create(Request $request)
    {
        $base_url = env('APP_URL');
        $headers = $this->getAuthorizationHeaders();

        $checklist_id = $request->route('id');
        $users = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/dashboard');
        
        return view('pages.section.create', ['page_title' => 'Add Section'],compact('users','checklist_id'));
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $base_url = env('APP_URL');
        $name = $request->name;
        $checklist_id = $request->checklist_id;
        $status = $request->status;

        $headers = $this->getAuthorizationHeaders();
        $response = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/create/section',[
            'name' => $name,
            'checklist_id' => $checklist_id,
            'status' => $status,
        ]);
        $result = json_decode((string)$response->getBody(),true);

        if($result['status'] == true){
            return redirect()->route('section',$checklist_id);
        }else{
            return redirect()->route('create_section',$checklist_id);
        }
    }

    /**
     * Display the specified resource.
     */
    public function show(Request $request)
    {
        $base_url = env('APP_URL');
        
        $headers = $this->getAuthorizationHeaders();
        $users = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/dashboard');

        $id = $request->route('id');
        $view_cate = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/show/section/'.$id,[
            'id' => $id
        ]);
        $checklist_view = $view_cate['data']['section'];
        return view('pages.section.update', ['page_title' => 'Update Section'],compact('users','id','checklist_view'));
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request)
    {
        $base_url = env('APP_URL');
        $headers = $this->getAuthorizationHeaders();

        $id = $request->id;
        $name = $request->name;
        $checklist_id = $request->checklist_id;
        $status = $request->status;

        $response = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/update/section',[
            'id' => $id,
            'name' => $name,
            'checklist_id' => $checklist_id,
            'status' => $status,
        ]);
        $result = json_decode((string)$response->getBody(),true);
        
        if($result['status'] == true){
            return redirect()->route('section',$checklist_id);
        }else{
            return redirect()->route('create_section',$checklist_id);
        }
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }
}
