<?php

namespace App\Http\Controllers\Dashboard;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Http;
use JWTAuth;
use PHPOpenSourceSaver\JWTAuth\Exceptions\JWTException;
use Illuminate\Support\Facades\Cookie;

class ScheduleController extends Controller
{
    
    /**
     * Display a listing of the resource.
     */
    private function getAuthorizationHeaders()
    {
        $token = Cookie::get('token');
        return [
            'Authorization' => 'Bearer '.$token,
            'Accept' => 'application/json',
        ];
    }

    public function schedule_list(){

        $base_url = env('APP_URL');

        $headers = $this->getAuthorizationHeaders();
        $response = Http::withHeaders($headers)->post($base_url.'/api/web/schedule');
        $data = $response->json();

        $schedules = $data['data']['schedule']; // Extract the 'Auditors' array from the JSON response
        
            if(isset($schedules) && !empty($schedules)) {

        $formattedData = array();
        foreach ($schedules as $schedule) {
            $formattedData[] = array(
                "id" => $schedule["id"],
                "avatar" => $schedule["avatar"],
                "title" => $schedule["title"],
                "category" => $schedule["category"],
                "location" => $schedule["location"],
                "audited_by" => $schedule["audited_by"],
                "campany_department" => $schedule["campany_department"],
                "scheduled_on" => $schedule["scheduled_on"],
                "status" => $schedule["status"],
                "progress" => $schedule["progress"],
            );
        }
        
            } else {

                $formattedData = []; // or assign a default value
            
            }
        
        $response = array("data" => $formattedData);
        
        // Convert the response array to JSON
        return response()->json($response);
        

    }

    public function add_schedule(Request $request){

      
        
        $base_url = env('APP_URL');
        $headers = $this->getAuthorizationHeaders();
        
        $response = Http::withHeaders($headers);
        

        
        $response = $response->post($base_url.'/api/web/create/schedule', [
            'company_id' => $request->company_id,
            'checklist_id' => $request->checklist_id,
            'location_id' => $request->location_id,
            'auditor_id' => $request->auditor_id,
            'schedule_on' => $request->schedule_on,
            'start_time' => $request->start_time,
            'end_time' => $request->end_time,
        ]);


            if ($response->status() === 200) {

            $responseData = $response->json();

            return $responseData;

        } else {
            $errorData = $response->json();

            return $errorData;
        }


    }


    public function delete_schedule(Request $request){
       
        $base_url = env('APP_URL');
        $headers = $this->getAuthorizationHeaders();
        
        $response = Http::withHeaders($headers);
        
        $response = $response->post($base_url.'/api/web/delete/schedule/'.$request->id, [
            'id' => $request->id,
            'status' => '4',
        ]);

        $data = $response->json();


            if ($response->status() === 200) {

            $responseData = $response->json();

            return $responseData;

        } else {
            $errorData = $response->json();

            return $errorData;
        }


    }

}