<?php

namespace App\Http\Controllers\Dashboard;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

use Illuminate\Support\Facades\Http;
use JWTAuth;
use PHPOpenSourceSaver\JWTAuth\Exceptions\JWTException;
use Illuminate\Support\Facades\Cookie;

class RolesController extends Controller
{
    public $page_title;
    public function __construct() {
        $this->page_title  = '';
    }
    private function getAuthorizationHeaders()
    {
        $token = Cookie::get('token');
        return [
            'Authorization' => 'Bearer '.$token,
            'Accept' => 'application/json',
        ];
    }

    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $base_url = env('APP_URL');

        $headers = $this->getAuthorizationHeaders();
        $users = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/roles');

        // return dd($users);
        return view('pages.roles', ['page_title' => 'Roles & Hierarchy'],compact('users'));
    }

    public function list()
    {
        $base_url = env('APP_URL');

        $headers = $this->getAuthorizationHeaders();
        $users = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/roles');

        $userslist = [
            'data' => $users['data']['userslist']
        ];

        return $userslist;
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request)
    {
        $base_url = env('APP_URL');
        $headers = $this->getAuthorizationHeaders();

        $id = $request->id;
        $status = $request->status;

        $response = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/update/roles',[
            'id' => $id,
            'status' => $status,
        ]);
        $result = json_decode((string)$response->getBody(),true);
        
        

        if($result['status'] == true){
            return redirect()->route('roles');
        }else{
            return redirect()->route('roles');
        }
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }
}
