<?php

namespace App\Http\Controllers\Dashboard;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

use Illuminate\Support\Facades\Http;
use JWTAuth;
use PHPOpenSourceSaver\JWTAuth\Exceptions\JWTException;
use Illuminate\Support\Facades\Cookie;

class ResultController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    private function getAuthorizationHeaders()
    {
        $token = Cookie::get('token');
        return [
            'Authorization' => 'Bearer '.$token,
            'Accept' => 'application/json',
        ];
    }

    public function index(Request $request)
    {
        $base_url = env('APP_URL');

        $headers = $this->getAuthorizationHeaders();

        $users = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/results');

        // return dd($users);
        return view('pages.results.index', ['page_title' => 'Results Management'],compact('users'));
    }

    public function list()
    {
        $base_url = env('APP_URL');

        $headers = $this->getAuthorizationHeaders();
        $users = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/results');

        $plans = [
            'data' => $users['data']['results']
        ];

        return $plans;
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        $base_url = env('APP_URL');
        
        $headers = $this->getAuthorizationHeaders();
        $users = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/dashboard');
        $category = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/checklist');
        return view('pages.results.create', ['page_title' => 'Add Results'],compact('users','category'));
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $base_url = env('APP_URL');
        $name = $request->name;
        $checklist_id = $request->checklist_id;
        $symbols = $request->symbols;
        $percentage = $request->percentage;
        $color = $request->color;
        $status = $request->status;

        $headers = $this->getAuthorizationHeaders();
        $response = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/create/results',[
            'name' => $name,
            'checklist_id' => $checklist_id,
            'symbols' => $symbols,
            'percentage' => $percentage,
            'color' => $color,
            'status' => $status,
        ]);
        $result = json_decode((string)$response->getBody(),true);
        // return dd($result);
        if($result['status'] == true){
            return redirect()->route('results')->with('success',$result['message']);
        }else{
            return redirect()->route('create_results')->with('error',$result['message']);
        }
    }

    /**
     * Display the specified resource.
     */
    public function show(Request $request)
    {
        $base_url = env('APP_URL');
        
        $headers = $this->getAuthorizationHeaders();
        $users = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/dashboard');

        $id = $request->route('id');
        $view_cate = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/show/results/'.$id,[
            'id' => $id
        ]);
        $checklist_view = $view_cate['data']['results'];
        $category = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/checklist');
        return view('pages.results.update', ['page_title' => 'Update Checklist'],compact('users','id','checklist_view','category'));
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request)
    {
        $base_url = env('APP_URL');
        $headers = $this->getAuthorizationHeaders();

        $id = $request->id;
        $name = $request->name;
        $checklist_id = $request->checklist_id;
        $symbols = $request->symbols;
        $percentage = $request->percentage;
        $color = $request->color;
        $status = $request->status;

        $response = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/update/results',[
            'id' => $id,
            'name' => $name,
            'checklist_id' => $checklist_id,
            'symbols' => $symbols,
            'percentage' => $percentage,
            'color' => $color,
            'status' => $status,
        ]);
        $result = json_decode((string)$response->getBody(),true);
        
        // return dd($result);

        if($result['status'] == true){
            return redirect()->route('results')->with('success',$result['message']);
        }else{
            return redirect()->route('create_results')->with('error',$result['message']);
        }
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }

    public function delete(Request $request)
    {
        $base_url = env('APP_URL');
        $headers = $this->getAuthorizationHeaders();

        $id = $request->id;

        $response = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/delete/results',[
            'id' => $id
        ]);
        $result = json_decode((string)$response->getBody(),true);
        
        if($result['status'] == true){
            return redirect()->route('results')->with('success',$result['message']);
        }else{
            return redirect()->route('create_results')->with('error',$result['message']);
        }
    }
}
