<?php

namespace App\Http\Controllers\Dashboard;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

use Illuminate\Support\Facades\Http;
use JWTAuth;
use PHPOpenSourceSaver\JWTAuth\Exceptions\JWTException;
use Illuminate\Support\Facades\Cookie;

class ResetController extends Controller
{
    public $page_title;
    public function __construct() {
        $this->page_title  = '';
    }
    private function getAuthorizationHeaders()
    {
        return [
            'Accept' => 'application/json',
        ];
    }
    /**
     * Display a listing of the resource.
     */
    public function index(Request $request)
    {
        $base_url = env('APP_URL');
        $headers = $this->getAuthorizationHeaders();

        $token = $request->token;
        
        $response = Http::withHeaders($headers)->post($base_url.'/api/auth/web/reset?token='.$token,[
            'token' => $token
        ]);
        $result = json_decode((string)$response->getBody(),true);
        

        if($result['status'] == true){
            $id = $response['data']['id']; 
            $email = $response['data']['email']; 
            return view('pages.authentication.reset', ['page_title' => 'Reset Password'],compact('token','id','email'));
        }else{
            return redirect()->route('forgot_password')->with('error',$result['message']);
        }
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request)
    {
        try{
            $base_url = env('APP_URL');
            $headers = $this->getAuthorizationHeaders();
    
            $id = $request->id;
            $password = $request->password;
            $password_confirmation = $request->password_confirmation;
    
            $response = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/auth/web/change-password',[
                'id' => $id,
                'password' => $password,
                'password_confirmation' => $password_confirmation,
            ]);
            $result = json_decode((string)$response->getBody(),true);
            // return dd($result);
            if($result['status'] == true){
                return redirect()->route('login')->with('success',$result['message']);
            }else{
                return redirect()->back()->with('error',$result['message']);
            }
        }catch(\Exception $e){
            return redirect()->back()->with('error',$result['message']);
        }
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }
}
