<?php

namespace App\Http\Controllers\Dashboard;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

use Illuminate\Support\Facades\Http;
use JWTAuth;
use PHPOpenSourceSaver\JWTAuth\Exceptions\JWTException;
use Illuminate\Support\Facades\Cookie;

class ReportsController extends Controller
{
    public $page_title;
    public function __construct() {
        $this->page_title  = '';
    }
    private function getAuthorizationHeaders()
    {
        $token = Cookie::get('token');
        return [
            'Authorization' => 'Bearer '.$token,
            'Accept' => 'application/json',
        ];
    }
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $base_url = env('APP_URL');

        $headers = $this->getAuthorizationHeaders();
        $users = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/reports');

        // return dd($users);
        return view('pages.reports.index', ['page_title' => 'Report'],compact('users'));
    }

    public function list()
    {
        $base_url = env('APP_URL');

        $headers = $this->getAuthorizationHeaders();
        $auditreport = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/reports');
		
		$flattenedData = [];
		foreach ($auditreport['data']['auditreport'] as $array) {
			$flattenedData = array_merge($flattenedData, $array);
		}

        $auditreport = [
            'data' => $flattenedData
        ];

        return $auditreport;
    }
    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }
    
    public function print(Request $request){
        $base_url = env('APP_URL');

        $headers = $this->getAuthorizationHeaders();
        $audit_id = $request->route('audit_id');
        $audits = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/print/reports/'.$audit_id,[
            'audit_id' => $audit_id
        ]);
        $data = $audits['data']['printlist'][0];
        return view('pages.reports.print', ['page_title' => 'Print Reports'],compact('data'));
		//return $data;
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request)
    {
        $base_url = env('APP_URL');
        $headers = $this->getAuthorizationHeaders();

        $audit_id = $request->audit_id;
        $status = $request->status;

        $response = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/update/reports',[
            'audit_id' => $audit_id,
            'status' => $status,
        ]);
        $result = json_decode((string)$response->getBody(),true);
        
        if($result['status'] == true){
            return redirect()->route('reports')->with('success',$result['message']);
        }else{
            return redirect()->route('reports')->with('error',$result['message']);
        }
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }
}
