<?php

namespace App\Http\Controllers\Dashboard;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

use Illuminate\Support\Facades\Http;
use JWTAuth;
use PHPOpenSourceSaver\JWTAuth\Exceptions\JWTException;
use Illuminate\Support\Facades\Cookie;

class RenewalController extends Controller
{
    public $page_title;
    public function __construct() {
        $this->page_title  = '';
    }
    private function getAuthorizationHeaders()
    {
        $token = Cookie::get('token');
        return [
            'Authorization' => 'Bearer '.$token,
            'Accept' => 'application/json',
        ];
    }

    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $base_url = env('APP_URL');

        $headers = $this->getAuthorizationHeaders();
        $users = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/renewal');

        // return dd(json_decode($users));
        return view('pages.renewal', ['page_title' => 'Renewal & Cancellation'],compact('users'));
    }

    public function list()
    {
        $base_url = env('APP_URL');

        $headers = $this->getAuthorizationHeaders();
        $users = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/renewal');

        $category = [
            'data' => $users['data']['invoice']
        ];

        return $category;
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }
}
