<?php

namespace App\Http\Controllers\Dashboard;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Hash;
use App\Models\User;
use App\Models\Plans;

class RegisterController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        return view('pages.authentication.signup', ['page_title' => 'Register Here']);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        try{
            $plans = Plans::where('id' ,1)->get()->first();
            $base_url = env('APP_URL');

            $characters = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
            $pin = rand(10, 50)
            . rand(10, 50)
            . $characters[rand(0, strlen($characters) - 1)];
            $string = str_shuffle($pin);

            $user_id = 'CI-'.$string;
            $first_name = $request->first_name;
            $last_name = $request->last_name;
            $email = $request->email;
            $country_name = $request->country_name;
            $country_code = $request->country_code;
            $mobile_no = $request->mobile_no;
            $password = $request->password;
            $password_confirmation = $request->password_confirmation;
            $role = "2";
            $permission = "2";
            $gender = 0;
            $plan_day_remain = $plans->days;
            $plan_actived = 1;
            $status = 2;
            $response = Http::timeout(60)->withHeaders(['Authorization' => 'Bearer'.session()->get('token.token')])->accept('application/json')->post($base_url.'/api/auth/register',[
                'user_id' => $user_id,
                'first_name' => $first_name,
                'last_name' => $last_name,
                'email' => $email,
                'country_name' => $country_name,
                'country_code' => $country_code,
                'mobile_no' => str_replace(' ', '', $mobile_no),
                'password' => $password,
                'password_confirmation' => $password_confirmation,
                'role' => $role,
                'permission' => $permission,
                'gender' => $gender,
                'plan_day_remain' => $plan_day_remain,
                'plan_actived' => $plan_actived,
                'status' => $status
            ]);
            $result = json_decode((string)$response->getBody(),true);

            // return dd($result);
            $status = $result['status'];
            if($status == false){
                return redirect()->back()->with('error',$result['message']);
            }else{
                return redirect()->route('thank_you')->with('success',$result['message']);
            }
        }catch(\Exception $e){
            
            if(array_key_exists("email",$result['errors'])){
                if($result['errors']['email'][0] == 'The email has already been taken.'){
                    $error = $result['errors']['email'][0];
                }
            }else{
                $error = '<ul class="mb-0">';
                if(array_key_exists("first_name",$result['errors'])){$error .= '<li>'.$result['errors']['first_name'][0].'</li>';}
                if(array_key_exists("last_name",$result['errors'])){$error .= '<li>'.$result['errors']['last_name'][0].'</li>';}
                if(array_key_exists("email",$result['errors'])){$error .= '<li>'.$result['errors']['email'][0].'</li>';}
                if(array_key_exists("password",$result['errors'])){$error .= '<li>'.$result['errors']['password'][0].'</li>';}
                if(array_key_exists("mobile_no",$result['errors'])){$error .= '<li>'.$result['errors']['mobile_no'][0].'</li>';}
                $error .= '</ul>';
            }
            return redirect()->back()->with('error',$error);
        }
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }
}
