<?php

namespace App\Http\Controllers\Dashboard;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

use Illuminate\Support\Facades\Http;
use JWTAuth;
use PHPOpenSourceSaver\JWTAuth\Exceptions\JWTException;
use Illuminate\Support\Facades\Cookie;

class QuestionsController extends Controller
{
    public $page_title;
    public function __construct() {
        $this->page_title  = '';
    }
    private function getAuthorizationHeaders()
    {
        $token = Cookie::get('token');
        return [
            'Authorization' => 'Bearer '.$token,
            'Accept' => 'application/json',
        ];
    }
    /**
     * Display a listing of the resource.
     */
    public function index(Request $request)
    {
        //question
        $base_url = env('APP_URL');

        $headers = $this->getAuthorizationHeaders();

        $checklist_id = $request->route('id');
        $users = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/questions');
        return view('pages.question.index', ['page_title' => 'Questions Management'],compact('users','checklist_id'));
    }

    public function list(Request $request)
    {
        $base_url = env('APP_URL');

        $headers = $this->getAuthorizationHeaders();
        
        $checklist_id = $request->route('id');
        $users = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/questions',[
            'checklist_id' => $checklist_id
        ]);

        $question_list = [
            'data' => $users['data']['question_list']
        ];

        return $question_list;
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create(Request $request)
    {
        $base_url = env('APP_URL');
        $headers = $this->getAuthorizationHeaders();

        $checklist_id = $request->route('id');
        $users = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/dashboard');

        $section = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/section',[
            'checklist_id' => $checklist_id
        ]);
        
        return view('pages.question.create', ['page_title' => 'Add Questions'],compact('users','checklist_id','section'));
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $base_url = env('APP_URL');
        $title = $request->title;
        $type = $request->type;

        if($type == 'radio-group'){
            $option_array = '{"name": "radio-group-1714645549258-0", "type": "radio-group", "label": "'.$title.'", "other": false, "access": false, "inline": false, "values": [{"label": "Yes", "value": "Yes", "selected": false}, {"label": "No", "value": "No", "selected": false}, {"label": "N/A", "value": "N/A", "selected": false}], "required": false}';
        }elseif($type == 'text-group'){
            $option_array = '{"type": "text","required": false,"label": "'.$title.'","className": "form-control","name": "text-1715746657246-0","access": false,"subtype": "text"}';
        }else{
            $option_array = '{"type":"checkbox-group","required":false,"label":"'.$title.'","toggle":false,"inline":false,"name":"checkbox-group-1715746980449-0","access":false,"other":false,"values":[{"label":"Yes","value":"Yes","selected":true}]}';
        }
        
        $section_id = $request->section_id;
        $checklist_id = $request->checklist_id;
        $status = $request->status;

        $headers = $this->getAuthorizationHeaders();
        $response = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/create/questions',[
            'title' => $title,
            'type' => $type,
            'option_array' => $option_array,
            'section_id' => $section_id,
            'checklist_id' => $checklist_id,
            'status' => $status,
        ]);
        $result = json_decode((string)$response->getBody(),true);

        if($result['status'] == true){
            return redirect()->route('question',$checklist_id);
        }else{
            return redirect()->route('create_question',$checklist_id);
        }
    }

    /**
     * Display the specified resource.
     */
    public function show(Request $request)
    {
        $base_url = env('APP_URL');
        
        $headers = $this->getAuthorizationHeaders();
        $users = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/dashboard');

        $id = $request->route('id');
        $view_cate = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/show/questions/'.$id,[
            'id' => $id
        ]);
        $checklist_view = $view_cate['data']['question'];
        return view('pages.question.update', ['page_title' => 'Update Question'],compact('users','id','checklist_view'));
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Request $request)
    {
        $base_url = env('APP_URL');
        $headers = $this->getAuthorizationHeaders();

        $id = $request->id;
        $type = $request->type;
        $status = $request->status;

        $admin_message = $request->admin_message;
        $json_section = json_decode($admin_message, true);
        $title = $json_section[0]['label'];
        $checklist_id = $request->checklist_id;
        // return dd($json_section,$json_section[0]['label'], json_encode($json_section[0]));
        $response = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/edit/questions',[
            'id' => $id,
            'title' => $title,
            'type' => $type,
            'option_array' => json_encode($json_section[0]),
            'status' => $status,
        ]);
        
        $result = json_decode((string)$response->getBody(),true);

        if($result['status'] == true){
            return redirect()->route('question',$checklist_id)->with('success',$result['message']);
        }else{
            return redirect()->route('edit_question',$id)->with('error',$result['message']);
        }
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request)
    {
        $base_url = env('APP_URL');
        $headers = $this->getAuthorizationHeaders();

        $id = $request->id;
        $status = $request->status;
        $checklist_id = $request->checklist_id;

        $response = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/update/questions',[
            'id' => $id,
            'status' => $status,
        ]);
        $result = json_decode((string)$response->getBody(),true);
        
        if($result['status'] == true){
            return redirect()->route('question',$checklist_id);
        }else{
            return redirect()->route('create_question',$checklist_id);
        }
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }
}
