<?php

namespace App\Http\Controllers\Dashboard;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

use Illuminate\Support\Facades\Http;
use JWTAuth;
use PHPOpenSourceSaver\JWTAuth\Exceptions\JWTException;
use Illuminate\Support\Facades\Cookie;

class PlansController extends Controller
{
    public $page_title;
    public function __construct() {
        $this->page_title  = '';
    }
    private function getAuthorizationHeaders()
    {
        $token = Cookie::get('token');
        return [
            'Authorization' => 'Bearer '.$token,
            'Accept' => 'application/json',
        ];
    }
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $base_url = env('APP_URL');

        $headers = $this->getAuthorizationHeaders();
        $users = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/plans');

        // return dd($users);
        return view('pages.plans.index', ['page_title' => 'Plans'],compact('users'));
    }

    public function list()
    {
        $base_url = env('APP_URL');

        $headers = $this->getAuthorizationHeaders();
        $users = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/plans');

        $plans = [
            'data' => $users['data']['plans']
        ];

        return $plans;
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     */
    public function show(Request $request)
    {
        $base_url = env('APP_URL');
        
        $headers = $this->getAuthorizationHeaders();
        $users = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/dashboard');

        $id = $request->route('id');
        $view_plans = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/show/plans/'.$id,[
            'id' => $id
        ]);
        $plans_view = $view_plans['data']['plans'][0];
        return view('pages.plans.update', ['page_title' => 'Update Plans'],compact('users','id','plans_view'));
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request)
    {
        try{
            $base_url = env('APP_URL');
            $headers = $this->getAuthorizationHeaders();
    
            $id = $request->id;
            $title = $request->title;
            $subtitle = $request->subtitle;
            $amount = $request->amount;
            $days = $request->days;
            $feature = $request->feature;
            $status = $request->status;
    
            $response = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/update/plans',[
                'id' => $id,
                'title' => $title,
                'subtitle' => $subtitle,
                'amount' => $amount,
                'days' => $days,
                'feature' => $feature,
                'status' => $status,
            ]);
            $result = json_decode((string)$response->getBody(),true);
            // return dd($result);
            if($result['status'] == true){
                return redirect()->route('plans')->with('success',$result['message']);
            }else{
                return redirect()->route('update_plans',$id)->with('error',$result['message']);
            }
        }catch(\Exception $e){
            return redirect()->back()->with('error',$result['message']);
        }
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }
}
