<?php

namespace App\Http\Controllers\Dashboard;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

use Illuminate\Support\Facades\Http;
use JWTAuth;
use PHPOpenSourceSaver\JWTAuth\Exceptions\JWTException;
use Illuminate\Support\Facades\Cookie;

use App\Models\User;
use App\Models\Invoice;

class PageController extends Controller
{
    public $page_title;
    public function __construct() {
        $this->page_title  = '';
    }
    private function getAuthorizationHeaders()
    {
        $token = Cookie::get('token');
        return [
            'Authorization' => 'Bearer '.$token,
            'Accept' => 'application/json',
        ];
    }
    public function privacypolicy(){
        return view('privacy-policy', ['page_title' => 'Privacy Policy']);
    }
	public function termsandconditions(){
        return view('terms-and-conditions', ['page_title' => 'Terms and Conditions']);
    }
    public function login(){
        return view('pages.authentication.login', ['page_title' => 'Login']);
    }
    public function thankyou(){
        return view('pages.authentication.thankyou', ['page_title' => 'Thank You']);
    }
    public function signup(){
        return view('pages.authentication.signup', ['page_title' => 'Register Here']);
    }
    public function forgot(){
        return view('pages.authentication.forgot', ['page_title' => 'Forgot Password']);
    }
    public function reset(){
        return view('pages.authentication.reset', ['page_title' => 'Reset Password']);
    }
    public function dashboard(){

        return view('pages.dashboard', ['page_title' => 'Dashboard']);
    }
    public function users(){
        $base_url = env('APP_URL');
        
        $headers = $this->getAuthorizationHeaders();
        $users = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/dashboard');
        return view('pages.users.index', ['page_title' => 'Dashboard'],compact('users'));
    }
    public function categorys(){
        $base_url = env('APP_URL');
        
        $headers = $this->getAuthorizationHeaders();
        $users = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/dashboard');
        return view('pages.categorys.index', ['page_title' => 'Category'],compact('users'));
    }
    public function createcategorys(){
        $base_url = env('APP_URL');
        
        $headers = $this->getAuthorizationHeaders();
        $users = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/dashboard');
        return view('pages.categorys.create', ['page_title' => 'Add Category'],compact('users'));
    }
    public function roles(){
        $base_url = env('APP_URL');
        
        $headers = $this->getAuthorizationHeaders();
        $users = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/dashboard');
        return view('pages.roles', ['page_title' => 'Roles & Hierarchy'],compact('users'));
    }
    public function plans(){
        $base_url = env('APP_URL');
        
        $headers = $this->getAuthorizationHeaders();
        $users = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/dashboard');
        return view('pages.plans', ['page_title' => 'Plan Customization'],compact('users'));
    }
    public function billing(){
        $base_url = env('APP_URL');
        
        $headers = $this->getAuthorizationHeaders();
        $users = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/dashboard');
        return view('pages.billing', ['page_title' => 'Billing & Invoicing'],compact('users'));
    }
    public function renewal(){
        $base_url = env('APP_URL');
        
        $headers = $this->getAuthorizationHeaders();
        $users = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/dashboard');
        return view('pages.renewal', ['page_title' => 'Renewal & Cancellation'],compact('users'));
    }
    public function checklist(){
        $base_url = env('APP_URL');
        
        $headers = $this->getAuthorizationHeaders();
        $users = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/dashboard');
        return view('pages.checklist.index', ['page_title' => 'Checklist Management'],compact('users'));
    }
    public function createchecklist(){
        $base_url = env('APP_URL');
        
        $headers = $this->getAuthorizationHeaders();
        $users = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/dashboard');
        return view('pages.checklist.create', ['page_title' => 'Create Checklist'],compact('users'));
    }
    public function feedback(){
        $base_url = env('APP_URL');
        
        $headers = $this->getAuthorizationHeaders();
        $users = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/dashboard');
        return view('pages.feedback.index', ['page_title' => 'Feedback Management'],compact('users'));
    }
    public function updatefeedback(){
        $base_url = env('APP_URL');
        
        $headers = $this->getAuthorizationHeaders();
        $users = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/dashboard');
        return view('pages.feedback.update', ['page_title' => 'Update Feedback'],compact('users'));
    }
    public function templates(){
        $base_url = env('APP_URL');
        
        $headers = $this->getAuthorizationHeaders();
        $users = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/dashboard');
        $category = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/category');
        $checklist = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/checklist_template');
        
        return view('pages.templates', ['page_title' => 'Templates'],compact('users','category','checklist'));
    }
    public function emailtemplates(){
        $base_url = env('APP_URL');
        
        $headers = $this->getAuthorizationHeaders();
        $users = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/dashboard');
        return view('pages.email_templates', ['page_title' => 'Email Templates'],compact('users'));
    }
    public function auditors(){
        $base_url = env('APP_URL');
        
        $headers = $this->getAuthorizationHeaders();
        $users = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/dashboard');
        return view('pages.users.auditors', ['page_title' => 'Auditors Management'],compact('users'));
    }
    public function createauditors(){
        $base_url = env('APP_URL');
        
        $headers = $this->getAuthorizationHeaders();
        $users = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/dashboard');
        $companyResponse = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/department');
        $companies = $companyResponse->json();
        // return view('pages.users.createauditors', ['page_title' => 'Create Auditors'],compact('users'));
        return view('pages.users.createauditors', [
            'page_title' => 'Create Location',
            'users' => $users,
            'companies' => $companies
        ]);
    }
     public function updateauditors(Request $request){
        $base_url = env('APP_URL');
        
        $headers = $this->getAuthorizationHeaders();
        $users = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/dashboard');

            if(isset($request->id)) {
                $response = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/show/auditor/'.$request->id, [
                    'id' => $request->id,
                ]);
                $data = $response->json();
            } else {
                // Handle the case where $request->id is not set
                $data = []; // or handle as appropriate
            }

        $companyResponse = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/department');
    
        $companies = $companyResponse->json();

        return view('pages.users.updateauditors', [
            'page_title' => 'Update Auditors',
            'companies' => $companies,
            'auditors' => $data, 
            'users' => $users, 
        ]);
    }
    public function companydepartment(){
        $base_url = env('APP_URL');
        
        $headers = $this->getAuthorizationHeaders();
        $users = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/dashboard');
        return view('pages.users.companydepartment', ['page_title' => 'Company / Department'],compact('users'));
    }
    public function createcompanydepartment(){
        $base_url = env('APP_URL');
        
        $headers = $this->getAuthorizationHeaders();
        $users = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/dashboard');
        return view('pages.users.createcompanydepartment', ['page_title' => 'Create Company / Department'],compact('users'));
    }
    public function updatecompany(Request $request){
        $base_url = env('APP_URL');
        
        $headers = $this->getAuthorizationHeaders();
        $users = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/dashboard');

            if(isset($request->id)) {
                $response = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/show/department/'.$request->id, [
                    'id' => $request->id,
                ]);
                $data = $response->json();
            } else {
                // Handle the case where $request->id is not set
                $data = []; // or handle as appropriate
            }

        return view('pages.users.updatecompanydepartment', [
            'page_title' => 'Update Company',
            'department' => $data, // Pass the auditor data to the view
            'users' => $users, 
        ]);
    }
 public function schedule(){
        $base_url = env('APP_URL');
        
        $headers = $this->getAuthorizationHeaders();
        $users = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/dashboard');
        return view('pages.schedule.index', ['page_title' => 'Schedule'],compact('users'));
    }
    public function createschedule(){
        $base_url = env('APP_URL');
        
        $headers = $this->getAuthorizationHeaders();
        $users = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/dashboard');
        // return view('pages.schedule.create', ['page_title' => 'Create Schedule'],compact('users'));

        $companyResponse = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/department');
        $companies = $companyResponse->json();

        $locationResponse = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/locations');
        $locations = $locationResponse->json();

        $auditorResponse = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/auditor');
        $auditors = $auditorResponse->json();

        $checklistResponse = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/checklist');
        $checklists = $checklistResponse->json();

        return view('pages.schedule.create', [
            'page_title' => 'Create Schedule',
            'users' => $users,
            'companies' => $companies,
            'locations' => $locations,
            'auditors' => $auditors,
            'checklists' => $checklists
        ]);

    }
    public function locations(){
        $base_url = env('APP_URL');
        
        $headers = $this->getAuthorizationHeaders();
        $users = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/dashboard');
        return view('pages.locations.index', ['page_title' => 'Location'],compact('users'));
    }
    public function createlocations(){
        $base_url = env('APP_URL');
        
        $headers = $this->getAuthorizationHeaders();
        $users = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/dashboard');
        $companyResponse = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/department');

        // return view('pages.locations.create', ['page_title' => 'Create Location'],compact('users'));

        $companies = $companyResponse->json();
    
        return view('pages.locations.create', [
            'page_title' => 'Create Location',
            'users' => $users,
            'companies' => $companies
        ]);
    }
    public function updatelocation(Request $request){
        $base_url = env('APP_URL');
        
        $headers = $this->getAuthorizationHeaders();
        $users = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/dashboard');

            if(isset($request->id)) {
                $response = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/show/locations/'.$request->id, [
                    'id' => $request->id,
                ]);
                $data = $response->json();
            } else {
                // Handle the case where $request->id is not set
                $data = []; // or handle as appropriate
            }

            $companyResponse = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/department');
        
            $companies = $companyResponse->json();

        return view('pages.locations.update', [
            'page_title' => 'Update Location',
            'companies' => $companies,
            'location' => $data, // Pass the auditor data to the view
            'users' => $users, 
        ]);
    }
    public function formbuilder(){
        $base_url = env('APP_URL');
        
        $headers = $this->getAuthorizationHeaders();
        $users = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/dashboard');
        $checklists = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/checklist');
        $category = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/category');
        $checklist = [
            'data' => $checklists['data']['checklist']
        ];
        // return $checklist;
        return view('pages.builder.index', ['page_title' => 'Form Builder'],compact('users','checklist','category'));
    }
    public function subscription(){
        $base_url = env('APP_URL');
        
        $headers = $this->getAuthorizationHeaders();
        $users = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/dashboard');

        $planResponse = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/plan');
        $plan = $planResponse->json();
        // return view('pages.plan.subscription', ['page_title' => 'Subscription Plan'],compact('users'));
        return view('pages.plan.subscription', [
            'page_title' => 'Subscription Plan',
            'plans' => $plan,
            'users' => $users, 
        ]);
    }

    public function payment(Request $request){
        $base_url = env('APP_URL');
        
        $headers = $this->getAuthorizationHeaders();
        $users = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/dashboard');
        $gateway = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/gateway');


        if(isset($request->id)) {
            $planResponse = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/plan/'.$request->id, [
                'id' => $request->id,
            ]);
            $data = $planResponse->json();
        } else {
            // Handle the case where $request->id is not set
            $data = []; // or handle as appropriate
        }

        return view('pages.plan.payment', [
            'page_title' => 'Payment',
            'plans' => $data,
            'users' => $users, 
            'gateways' => $gateway,
            'id' => $request->id,
        ]);
    }

    public function gateway(){
        $base_url = env('APP_URL');
        
        $headers = $this->getAuthorizationHeaders();
        $users = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/dashboard');
        return view('pages.gateway.index', ['page_title' => 'Payment Gateway'],compact('users'));
    }

    public function updategateway(Request $request){
        $base_url = env('APP_URL');
        
        $headers = $this->getAuthorizationHeaders();
        $users = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/dashboard');

            if(isset($request->id)) {
                $response = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/show/gateway/'.$request->id, [
                    'id' => $request->id,
                ]);
                $data = $response->json();
            } else {
                // Handle the case where $request->id is not set
                $data = []; // or handle as appropriate
            }

        return view('pages.gateway.update', [
            'page_title' => 'Update Payment Gateway',
            'gateway' => $data, // Pass the auditor data to the view
            'users' => $users, 
        ]);
    }
    
    public function dayscount()
    {
        $user_count = User::where('role', 2)->get();
        $userlist = [];
        
        for($ab = 0; $ab < count($user_count); $ab++){
            $invoice = Invoice::where('created_by', $user_count[$ab]['id'])->orderBy('created_at','DESC')->get()->first();

            $day_remain = now()->diffInDays($invoice['billing_end_date']);
            if($invoice['billing_end_date'] >= now()){
                $userlist[] = [
                    'days_remain' => $day_remain,
                    'userid' => $user_count[$ab]['id'],
                    'current_date' => now(),
                    'expire_date' => $invoice['billing_end_date'],
                ];
                $Expire = User::where('id',$invoice['created_by'])->update([
                    'plan_day_remain' => $day_remain
                ]);
                $Expire = User::where('created_by',$invoice['created_by'])->update([
                    'plan_day_remain' => $day_remain
                ]);
            }
            if($invoice['billing_end_date'] < now()){
                $userlist[] = [
                    'days_remain' => $day_remain,
                    'userid' => $user_count[$ab]['id'],
                    'current_date' => now(),
                    'expire_date' => $invoice['billing_end_date'],
                ];
                $Expire = User::where('id',$invoice['created_by'])->update([
                    'plan_day_remain' => 0
                ]);
                $Expire = User::where('created_by',$invoice['created_by'])->update([
                    'plan_day_remain' => 0
                ]);
            }
        }
        return $userlist;
    }
}
