<?php

namespace App\Http\Controllers\Dashboard;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Cookie;


class LoginController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public $page_title;
    public function __construct() {
        $this->page_title  = '';
    }

    public function index()
    {
        return view('pages.authentication.login', ['page_title' => 'Login']);
    }

    public function loginpost(Request $request)
    {
        try{
            $email = $request->email;
            $password = $request->password;
            $base_url = env('APP_URL');

            $response = Http::timeout(60)->withHeaders(['Authorization' => 'Bearer'.session()->get('token')])->accept('application/json')->post($base_url.'/api/auth/loginweb',[
                'email' => $email,
                'password' => $password
            ]);
            $result = json_decode((string)$response->getBody(),true);

            $status = $result['status'];
            
            if($status == false){
                return redirect()->back()->with('error',$result['message']);
            }else{
                $token = $result['data']['authorization']['token'];
                if(($result['data']['profile']['company_id'] != null && $result['data']['profile']['role'] == 2) || $result['data']['profile']['role'] == 1){
                    return redirect()->route('dashboard')->withCookie('token' ,$token ,8640);
                }else{
                    return redirect()->route('templates')->withCookie('token' ,$token ,8640);
                }
            }
        }catch(\Exception $e){
            // return dd($result);
            $error = '<ul class="mb-0"><li>'.$result['errors']['email'][0].'</li><li>'.$result['errors']['password'][0].'</li></ul>';
            return redirect()->back()->with('error',html_entity_decode($error));
        }
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }
}
