<?php

namespace App\Http\Controllers\Dashboard;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Http;
use JWTAuth;
use PHPOpenSourceSaver\JWTAuth\Exceptions\JWTException;
use Illuminate\Support\Facades\Cookie;

class LocationController extends Controller
{
    
    /**
     * Display a listing of the resource.
     */
    private function getAuthorizationHeaders()
    {
        $token = Cookie::get('token');
        return [
            'Authorization' => 'Bearer '.$token,
            'Accept' => 'application/json',
        ];
    }

    public function location_list(){

        $base_url = env('APP_URL');

        $headers = $this->getAuthorizationHeaders();
        $response = Http::withHeaders($headers)->post($base_url.'/api/web/locations');
        $data = $response->json();
        
          $locations_list =  $data['data']['locations_list'];
        
        if(isset($locations_list) && !empty($locations_list)) {

      
        $formattedData = [];
        
        foreach ($locations_list as $location) {

        
            $formattedData[] = [
                "id" => $location["id"],
                "avatar" => $location["avatar"],
                "locations_code" => $location["locations_code"],
                "location" => $location["location"],
                "company" => $location["company"],
                "address_full" => $location["address_full"],
                "time_zone" => $location["time_zone"],
                "pincode_postcode" => $location["pincode_postcode"],
                "status" => $location["status"],
            ];
        }
        } else {

    $formattedData = []; // or assign a default value

}
        
        // Return the formatted data
        $response = ["data" => $formattedData];
        
        // Convert the response array to JSON
        return response()->json($response);
        

    }

    public function add_location(Request $request){
       
        $base_url = env('APP_URL');
        $headers = $this->getAuthorizationHeaders();
        
        $response = Http::withHeaders($headers);
               
        $response = $response->post($base_url.'/api/web/create/locations', [
            'company_id' => $request->company_id,
            'name' => $request->name,
            'time_zone' => $request->time_zone,
            'address' => $request->address,
            'postcode' => $request->postcode,
            'status' => '1',
        ]);


            if ($response->status() === 200) {

            $responseData = $response->json();

            return $responseData;

        } else {
            $errorData = $response->json();

            return $errorData;
        }


    }

    public function get_location(Request $request){

        $headers = $this->getAuthorizationHeaders();

        $base_url = env('APP_URL');
        
        $response = $response->post($base_url.'/api/web/show/locations/'+$request->id, [
            'id' => $request->id,
        ]);
        $data = $response->json();

        return $data;

    }

    public function update_location(Request $request){

        $images = $request->file('images');
        
        $base_url = env('APP_URL');
        $headers = $this->getAuthorizationHeaders();
        
        $response = Http::withHeaders($headers);
        
        if ($images) {
            $response->attach('images', file_get_contents($images->path()), $images->getClientOriginalName());
        }

        
        $response = $response->post($base_url.'/api/web/update/locations', [
            'company_id' => $request->company_id,
            'name' => $request->name,
            'time_zone' => $request->time_zone,
            'address' => $request->address,
            'postcode' => $request->postcode,
            'status' => $request->status,
            'id' => $request->id,
        ]);


            if ($response->status() === 200) {

            $responseData = $response->json();

            return $responseData;

        } else {
            $errorData = $response->json();

            return $errorData;
        }


    }

    public function delete_location(Request $request){
       
        $base_url = env('APP_URL');
        $headers = $this->getAuthorizationHeaders();
        
        $response = Http::withHeaders($headers);
        
        $response = $response->post($base_url.'/api/web/delete/locations/'.$request->id, [
            'id' => $request->id,
            'status' => '3',
        ]);

        $data = $response->json();


            if ($response->status() === 200) {

            $responseData = $response->json();

            return $responseData;

        } else {
            $errorData = $response->json();

            return $errorData;
        }


    }

}