<?php

namespace App\Http\Controllers\Dashboard;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

use Illuminate\Support\Facades\Http;
use JWTAuth;
use PHPOpenSourceSaver\JWTAuth\Exceptions\JWTException;
use Illuminate\Support\Facades\Cookie;

class InvoiceController extends Controller
{
    public $page_title;
    public function __construct() {
        $this->page_title  = '';
    }
    private function getAuthorizationHeaders()
    {
        $token = Cookie::get('token');
        return [
            'Authorization' => 'Bearer '.$token,
            'Accept' => 'application/json',
        ];
    }

    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $base_url = env('APP_URL');

        $headers = $this->getAuthorizationHeaders();
        $users = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/invoice');

        // return dd($users);
        return view('pages.billing', ['page_title' => 'Billing & Invoicing'],compact('users'));
    }
    public function list()
    {
        $base_url = env('APP_URL');

        $headers = $this->getAuthorizationHeaders();
        $users = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/invoice');

        $category = [
            'data' => $users['data']['invoice']
        ];

        return $category;
    }
    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     */
    public function show(Request $request)
    {
        $base_url = env('APP_URL');
        
        $headers = $this->getAuthorizationHeaders();
        $users = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/dashboard');

        $id = $request->route('id');
        $users = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/view/invoice/'.$id,[
            'id' => $id
        ]);
        $invoice_view = $users['data']['company_profile'];
        return view('pages.billing.user', ['page_title' => 'Show Invoice'],compact('users','id','invoice_view'));
    }
    public function invoice_view(Request $request)
    {
        $base_url = env('APP_URL');

        $headers = $this->getAuthorizationHeaders();
        $id = $request->route('id');
        $users = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/view/invoice/'.$id,[
            'id' => $id
        ]);

        $company_profile = [
            'data' => $users['data']['company_profile']['invoice']
        ];

        return $company_profile;
    }
    public function showinvoice(Request $request){
        $base_url = env('APP_URL');

        $headers = $this->getAuthorizationHeaders();
        $id = $request->route('id');
        $users = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/print/invoice/'.$id,[
            'id' => $id
        ]);

        return view('pages.billing.download', ['page_title' => 'Invoice (Print version)'],compact('users'));
    }
    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }
}
