<?php

namespace App\Http\Controllers\Dashboard;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Http;
use JWTAuth;
use PHPOpenSourceSaver\JWTAuth\Exceptions\JWTException;
use Illuminate\Support\Facades\Cookie;

class GatewayController extends Controller
{
    
    /**
     * Display a listing of the resource.
     */
    private function getAuthorizationHeaders()
    {
        $token = Cookie::get('token');
        return [
            'Authorization' => 'Bearer '.$token,
            'Accept' => 'application/json',
        ];
    }

    public function gateway_list(){

        $base_url = env('APP_URL');

        $headers = $this->getAuthorizationHeaders();
        $response = Http::withHeaders($headers)->post($base_url.'/api/web/gateway');
        $data = $response->json();
        
          $gateway_list =  $data['data']['gateway'];
        
        if(isset($gateway_list) && !empty($gateway_list)) {

      
        $formattedData = [];
        
        foreach ($gateway_list as $gateway) {

        
            $formattedData[] = [
                "id" => $gateway["id"],
                "name" => $gateway["name"],
                "key_value" => $gateway["key_value"],
                "secret_value" => $gateway["secret_value"],
            ];
        }
        } else {

    $formattedData = []; // or assign a default value

}
        
        // Return the formatted data
        $response = ["data" => $formattedData];
        
        // Convert the response array to JSON
        return response()->json($response);
        

    }


    public function get_gateway(Request $request){

        $headers = $this->getAuthorizationHeaders();

        $base_url = env('APP_URL');
        
        $response = $response->post($base_url.'/api/web/show/gateway/'+$request->id, [
            'id' => $request->id,
        ]);
        $data = $response->json();

        return $data;

    }

    public function update_gateway(Request $request){

        
        $base_url = env('APP_URL');
        $headers = $this->getAuthorizationHeaders();
        
        $response = Http::withHeaders($headers);
      
        $response = $response->post($base_url.'/api/web/update/gateway', [
            'name' => $request->name,
            'key_value' => $request->key_value,
            'secret_value' => $request->secret_value,
            'id' => $request->id,
        ]);


            if ($response->status() === 200) {

            $responseData = $response->json();

            return $responseData;

        } else {
            $errorData = $response->json();

            return $errorData;
        }


    }

}