<?php

namespace App\Http\Controllers\Dashboard;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

use Illuminate\Support\Facades\Http;
use JWTAuth;
use PHPOpenSourceSaver\JWTAuth\Exceptions\JWTException;
use Illuminate\Support\Facades\Cookie;

class FeedbackController extends Controller
{
    public $page_title;
    public function __construct() {
        $this->page_title  = '';
    }
    private function getAuthorizationHeaders()
    {
        $token = Cookie::get('token');
        return [
            'Authorization' => 'Bearer '.$token,
            'Accept' => 'application/json',
        ];
    }
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $base_url = env('APP_URL');

        $headers = $this->getAuthorizationHeaders();
        $users = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/feedback');

        // return dd($users);
        return view('pages.feedback.index', ['page_title' => 'Feedback Management'],compact('users'));
    }
    public function list()
    {
        $base_url = env('APP_URL');

        $headers = $this->getAuthorizationHeaders();
        $users = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/feedback');

        $feedback = [
            'data' => $users['data']['feedback']
        ];

        return $feedback;
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        $base_url = env('APP_URL');
        
        $headers = $this->getAuthorizationHeaders();
        $users = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/dashboard');
        return view('pages.feedback.create', ['page_title' => 'Send Feedback'],compact('users'));
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        try{
            $base_url = env('APP_URL');
            $category = $request->category;
            $client_message = $request->client_message;

            $headers = $this->getAuthorizationHeaders();
            $response = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/create/feedback',[
                'category' => $category,
                'client_message' => $client_message
            ]);
            $result = json_decode((string)$response->getBody(),true);
            // return dd($result);
            if($result['status'] == true){
                return redirect()->route('support')->with('success',$result['message']);
            }else{
                return redirect()->route('support')->with('error',$result['message']);
            }
        }catch(\Exception $e){
            return redirect()->back()->with('error',$result['message']);
        }
    }

    /**
     * Display the specified resource.
     */
    public function show(Request $request)
    {
        $base_url = env('APP_URL');
        
        $headers = $this->getAuthorizationHeaders();
        $users = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/dashboard');

        $id = $request->route('id');
        $view_cate = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/show/feedback/'.$id,[
            'id' => $id
        ]);
        $feedback_view = $view_cate['data']['feedback'];
        return view('pages.feedback.update', ['page_title' => 'Update Feedback'],compact('users','id','feedback_view'));
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request)
    {
        try{
            $base_url = env('APP_URL');
            $headers = $this->getAuthorizationHeaders();
    
            $id = $request->id;
            $admin_message = $request->admin_message;
            $status = $request->status;
    
            $response = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/update/feedback',[
                'id' => $id,
                'admin_message' => $admin_message,
                'status' => $status,
            ]);
            $result = json_decode((string)$response->getBody(),true);
            // return dd(json_decode($response));
            
    
            if($result['status'] == true){
                return redirect()->route('feedback')->with('success',$result['message']);
            }else{
                return redirect()->route('update_feedback')->with('error',$result['message']);
            }
        }catch(\Exception $e){
            return redirect()->back()->with('error',$result['message']);
        }
        
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }
}
