<?php

namespace App\Http\Controllers\Dashboard;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Http;
use JWTAuth;
use PHPOpenSourceSaver\JWTAuth\Exceptions\JWTException;
use Illuminate\Support\Facades\Cookie;
use Carbon\Carbon;

class CompanyController extends Controller
{
    
    /**
     * Display a listing of the resource.
     */
    private function getAuthorizationHeaders()
    {
        $token = Cookie::get('token');
        return [
            'Authorization' => 'Bearer '.$token,
            'Accept' => 'application/json',
        ];
    }

    public function company_list(){

        $base_url = env('APP_URL');

        $headers = $this->getAuthorizationHeaders();
        $response = Http::withHeaders($headers)->post($base_url.'/api/web/department');
        $data = $response->json();

        $department_list =  $data['data']['department_list'];
        
           if(isset($department_list) && !empty($department_list)) {
        
        $formattedData = [];
        
        foreach ($department_list as $department) {
            $company_id = $department["id"];
            $company_name = $department["company_name"];
            $tags_name = $department["tags_name"];
            $last_modified = $department["last_modified"];
            $schedules_default_time_start = $department["schedules_default_time_start"];
            $schedules_default_time_end = $department["schedules_default_time_end"];
            
            // Assuming $schedules_default_time_start and $schedules_default_time_end are datetime strings in Indian Standard Time (IST)
            $start_datetime = Carbon::parse($schedules_default_time_start);
            $end_datetime = Carbon::parse($schedules_default_time_end);

            // Format datetime objects to display only time with timezone
            $start_time = $start_datetime->format('H:i');
            $end_time = $end_datetime->format('H:i');

            $start_time .= ' IST';
            $end_time .= ' IST';
            
            
            $status = $department["status"];
            
            // Include action assignees data
            $action_assignees = $department['action_assignees'];
        
            $formattedData[] = [
                "id" => $company_id,
                "company_name" => $company_name,
                "tags_name" => $tags_name,
                "last_modified" => $last_modified,
                "schedules_default_time_start" => $start_time,
                "schedules_default_time_end" => $end_time,
                "action_assignees" => $action_assignees,
                "status" => $status,
            ];
        }
        
        } else {

                $formattedData = []; // or assign a default value
            
            }
        
        // Return the formatted data
        $response = ["data" => $formattedData];
        
        // Convert the response array to JSON
        return response()->json($response);
        

    }

    public function add_company(Request $request){

        $images = $request->file('images');
        
        $base_url = env('APP_URL');
        $headers = $this->getAuthorizationHeaders();
        
        $response = Http::withHeaders($headers);
        
        if ($images) {
            $response->attach('images', file_get_contents($images->path()), $images->getClientOriginalName());
        }

        
        $response = $response->post($base_url.'/api/web/create/department', [
            'name' => $request->name,
            'schedules_start_time' => $request->schedules_start_time,
            'schedules_end_time' => $request->schedules_end_time,
            'password' => 'lensaudit',
            'role' => '1',
            'permission' => '1',
            'total_auditor_active' => '1',
            'total_auditor_inactive' => '1',
        ]);


            if ($response->status() === 200) {

            $responseData = $response->json();

            return $responseData;

        } else {
            $errorData = $response->json();

            return $errorData;
        }


    }

    public function get_company(Request $request){

        $headers = $this->getAuthorizationHeaders();

        $base_url = env('APP_URL');
        
        $response = $response->post($base_url.'/api/web/show/department/'+$request->id, [
            'id' => $request->id,
        ]);
        $data = $response->json();

        return $data;

    }

    public function update_company(Request $request){

        $images = $request->file('images');
        
        $base_url = env('APP_URL');
        $headers = $this->getAuthorizationHeaders();
        
        $response = Http::withHeaders($headers);
        
        if ($images) {
            $response->attach('images', file_get_contents($images->path()), $images->getClientOriginalName());
        }

        
        $response = $response->post($base_url.'/api/web/update/department', [
            'name' => $request->name,
            'schedules_start_time' => $request->schedules_start_time,
            'schedules_end_time' => $request->schedules_end_time,
            'plan_status' => $request->status,
            'id' => $request->id,
        ]);


            if ($response->status() === 200) {

            $responseData = $response->json();

            return $responseData;

        } else {
            $errorData = $response->json();

            return $errorData;
        }


    }

    public function delete_company(Request $request){
       
        $base_url = env('APP_URL');
        $headers = $this->getAuthorizationHeaders();
        
        $response = Http::withHeaders($headers);
        
        $response = $response->post($base_url.'/api/web/delete/department/'.$request->id, [
            'id' => $request->id,
            'status' => '3',
        ]);

        $data = $response->json();


            if ($response->status() === 200) {

            $responseData = $response->json();

            return $responseData;

        } else {
            $errorData = $response->json();

            return $errorData;
        }


    }

}