<?php

namespace App\Http\Controllers\Dashboard;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

use Illuminate\Support\Facades\Http;
use JWTAuth;
use PHPOpenSourceSaver\JWTAuth\Exceptions\JWTException;
use Illuminate\Support\Facades\Cookie;

class ChecklistController extends Controller
{
    public $page_title;
    public function __construct() {
        $this->page_title  = '';
    }
    private function getAuthorizationHeaders()
    {
        $token = Cookie::get('token');
        return [
            'Authorization' => 'Bearer '.$token,
            'Accept' => 'application/json',
        ];
    }

    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $base_url = env('APP_URL');

        $headers = $this->getAuthorizationHeaders();
        $users = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/checklist');

        // return dd($users);
        return view('pages.checklist.index', ['page_title' => 'Checklist Management'],compact('users'));
    }

    public function list()
    {
        $base_url = env('APP_URL');

        $headers = $this->getAuthorizationHeaders();
        $users = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/checklist');

        $checklist = [
            'data' => $users['data']['checklist']
        ];

        return $checklist;
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        $base_url = env('APP_URL');
        
        $headers = $this->getAuthorizationHeaders();
        $users = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/dashboard');
        $category = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/category');
        return view('pages.checklist.create', ['page_title' => 'Add Checklist'],compact('users','category'));
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $base_url = env('APP_URL');
        $name = $request->name;
        $category_id = $request->category_id;
        $status = $request->status;

        $headers = $this->getAuthorizationHeaders();
        $response = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/create/checklist',[
            'name' => $name,
            'category_id' => $category_id,
            'status' => $status,
        ]);
        $result = json_decode((string)$response->getBody(),true);

        if($result['status'] == true){
            return redirect()->route('checklist');
        }else{
            return redirect()->route('create_checklist');
        }
    }

    /**
     * Display the specified resource.
     */
    public function show(Request $request)
    {
        $base_url = env('APP_URL');
        
        $headers = $this->getAuthorizationHeaders();
        $users = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/dashboard');

        $id = $request->route('id');
        $view_cate = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/show/checklist/'.$id,[
            'id' => $id
        ]);
        $checklist_view = $view_cate['data']['checklist'];
        $category = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/category');
        return view('pages.checklist.update', ['page_title' => 'Update Checklist'],compact('users','id','checklist_view','category'));
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request)
    {
        $base_url = env('APP_URL');
        $headers = $this->getAuthorizationHeaders();

        $id = $request->id;
        $name = $request->name;
        $category_id = $request->category_id;
        $status = $request->status;

        $response = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/update/checklist',[
            'id' => $id,
            'name' => $name,
            'category_id' => $category_id,
            'status' => $status,
        ]);
        $result = json_decode((string)$response->getBody(),true);
        
        

        if($result['status'] == true){
            return redirect()->route('checklist');
        }else{
            return redirect()->route('create_checklist');
        }
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }
}
