<?php

namespace App\Http\Controllers\Dashboard;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

use Illuminate\Support\Facades\Http;
use JWTAuth;
use PHPOpenSourceSaver\JWTAuth\Exceptions\JWTException;
use Illuminate\Support\Facades\Cookie;

class CategoryController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public $page_title;
    public function __construct() {
        $this->page_title  = '';
    }
    private function getAuthorizationHeaders()
    {
        $token = Cookie::get('token');
        return [
            'Authorization' => 'Bearer '.$token,
            'Accept' => 'application/json',
        ];
    }

    public function index()
    {
        $base_url = env('APP_URL');

        $headers = $this->getAuthorizationHeaders();
        $users = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/category');

        // return dd($users);
        return view('pages.categorys.index', ['page_title' => 'Category'],compact('users'));
    }
    public function list()
    {
        $base_url = env('APP_URL');

        $headers = $this->getAuthorizationHeaders();
        $users = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/category');

        $category = [
            'data' => $users['data']['category']
        ];

        return $category;
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        $base_url = env('APP_URL');
        
        $headers = $this->getAuthorizationHeaders();
        $users = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/dashboard');
        return view('pages.categorys.create', ['page_title' => 'Add Category'],compact('users'));
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        try{
            $base_url = env('APP_URL');
            $name = $request->name;
            $status = $request->status;
    
            $headers = $this->getAuthorizationHeaders();
            $response = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/create/category',[
                'name' => $name,
                'status' => $status,
            ]);
            $result = json_decode((string)$response->getBody(),true);
    
            if($result['status'] == true){
                return redirect()->route('category')->with('success',$result['message']);
            }else{
                return redirect()->route('create_category')->with('error',$result['message']);
            }
        }catch(\Exception $e){
            return redirect()->back()->with('error',$result['message']);
        }
    }

    /**
     * Display the specified resource.
     */
    public function show(Request $request)
    {
        $base_url = env('APP_URL');
        
        $headers = $this->getAuthorizationHeaders();
        $users = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/dashboard');

        $id = $request->route('id');
        $view_cate = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/show/category/'.$id,[
            'id' => $id
        ]);
        $category_view = $view_cate['data']['category'];
        return view('pages.categorys.update', ['page_title' => 'Update Category'],compact('users','id','category_view'));
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request)
    {
        try{
            $base_url = env('APP_URL');
            $headers = $this->getAuthorizationHeaders();
    
            $id = $request->id;
            $name = $request->name;
            $status = $request->status;
            $status_action = $request->status_action;
    
            $response = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/update/category',[
                'id' => $id,
                'name' => $name,
                'status' => $status,
            ]);
            $result = json_decode((string)$response->getBody(),true);
            
            if($result['status'] == true){
                return redirect()->route('category')->with('success',$result['message']);
            }else{
                return redirect()->route('create_category')->with('error',$result['message']);
            }
        }catch(\Exception $e){
            return redirect()->back()->with('error',$result['message']);
        }
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }
    
    public function catcheck(Request $request)
    {
        $base_url = env('APP_URL');
        
        $headers = $this->getAuthorizationHeaders();
        $users = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/dashboard');

        $id = $request->route('id');
        // return dd($id);
        $view_cate = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/category/'.$id.'/checklist',[
            'id' => $id
        ]);
        // $category_view = $view_cate['data']['checklist'];
        $checklist = [
            'data' => $view_cate['data']['checklist']
        ];
        // return view('pages.categorys.update', ['page_title' => 'Checklist'],compact('users','id','category_view'));
        return $checklist;
    }
    public function catcheck_index(Request $request)
    {
        $base_url = env('APP_URL');

        $headers = $this->getAuthorizationHeaders();
        $users = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/category');
        
        $id = $request->route('id');
        // return dd($users);
        return view('pages.categorys.checklist', ['page_title' => 'Checklist Management'],compact('users','id'));
    }
}
