<?php

namespace App\Http\Controllers\Dashboard;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

use Illuminate\Support\Facades\Http;
use JWTAuth;
use PHPOpenSourceSaver\JWTAuth\Exceptions\JWTException;
use Illuminate\Support\Facades\Cookie;
use App\Models\ChecklistSection;

class BuilderController extends Controller
{
    public $page_title;
    public function __construct() {
        $this->page_title  = '';
    }
    private function getAuthorizationHeaders()
    {
        $token = Cookie::get('token');
        return [
            'Authorization' => 'Bearer '.$token,
            'Accept' => 'application/json',
        ];
    }

    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $base_url = env('APP_URL');
        
        $headers = $this->getAuthorizationHeaders();
        $users = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/dashboard');
        $checklists = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/checklist');
        $category = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/category');
        $checklist = [
            'data' => $checklists['data']['checklist']
        ];
        // return $checklist;
        return view('pages.builder.index', ['page_title' => 'Form Builder'],compact('users','checklist','category'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $base_url = env('APP_URL');
        $headers = $this->getAuthorizationHeaders();

        $admin_message = $request->admin_message;
        if(empty($admin_message)){
            return redirect()->route('formbuilder')->with('error','Form Builder can\'t be empty.');
        }
        
        $json_section = json_decode($admin_message, true);

        $array = json_decode($admin_message, true);
        $splitArrays = [];
        $currentArray = [];
        foreach ($array as $element) {
            if ($element['type'] === 'section') {
                if (!empty($currentArray)) {
                    $splitArrays[] = $currentArray;
                }
                $currentArray = [$element];
            } else {
                $currentArray[] = $element;
            }
        }
        if (!empty($currentArray)) {
            $splitArrays[] = $currentArray;
        }
        $jsonsplit = json_encode($splitArrays, JSON_PRETTY_PRINT);
        // return dd($splitArrays);
        for($a = 0; $a < count($splitArrays); $a++){
            $sectiondata = $splitArrays[$a];
            $data = collect($sectiondata);
            $questions = $data->where('type', '!=','section')->all();

            $name = $sectiondata[0]['label'];
            $checklist_id = $request->checklist_id;
            $status = "1";

            $section = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/create/section',[
                'name' => $name,
                'checklist_id' => $checklist_id,
                'status' => $status,
            ]);
            $sectionid = ChecklistSection::orderBy('id', 'desc')->get()->first();
            for($ia = 1; $ia <= count($questions); $ia++){
                $title = $questions[$ia]['label'];
                $type = $questions[$ia]['type'];
                $option_array = json_encode($questions[$ia]);
                $section_id = strval($sectionid['id']);

                $response = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/create/questions',[
                    'title' => $title,
                    'type' => $type,
                    'option_array' => $option_array,
                    'section_id' => $section_id,
                    'checklist_id' => $checklist_id,
                    'status' => $status,
                ]);
            }
        }

        $result = json_decode((string)$response->getBody(),true);
        // return dd($result);

        if($result['status'] == true){
            return redirect()->route('formbuilder')->with('success',$result['message']);
        }else{
            return redirect()->route('formbuilder')->with('error',$result['message']);
        }

        
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }
}
