<?php

namespace App\Http\Controllers\Dashboard;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Http;
use JWTAuth;
use PHPOpenSourceSaver\JWTAuth\Exceptions\JWTException;
use Illuminate\Support\Facades\Cookie;

class AuditorController extends Controller
{
    
    /**
     * Display a listing of the resource.
     */
    private function getAuthorizationHeaders()
    {
        $token = Cookie::get('token');
        return [
            'Authorization' => 'Bearer '.$token,
            'Accept' => 'application/json',
        ];
    }

    public function auditor_list(){

        $base_url = env('APP_URL');

        $headers = $this->getAuthorizationHeaders();
        $response = Http::withHeaders($headers)->post($base_url.'/api/web/auditor');
        $data = $response->json();
        

     $auditors = $data['data']['Auditors']; 
        
        if(isset($auditors) && !empty($auditors)) {

  

        $formattedData = array();
        foreach ($auditors as $auditor) {
            $formattedData[] = array(
                "id" => $auditor["id"],
                "user_id" => $auditor["user_id"],
                "full_name" => $auditor["full_name"],
                "email" => $auditor["email"],
                "mobile_no" => $auditor["mobile_no"],
                "job_title" => $auditor["job_title"],
                "company_name" => $auditor["company_name"],
                "access_app" => $auditor["access_app"],
                "access_web" => $auditor["access_web"],
                "status" => $auditor["status"],
                "created_at" => $auditor["created_at"],
            );
        }
        
        } else {

    $formattedData = []; // or assign a default value

}
        
        
        $response = array("data" => $formattedData);
        
        // Convert the response array to JSON
        return response()->json($response);
        

    }

    public function add_auditor(Request $request){

        $images = $request->file('images');
        
        $base_url = env('APP_URL');
        $headers = $this->getAuthorizationHeaders();
        
        $response = Http::withHeaders($headers);
        
        if ($images) {
            $response->attach('images', file_get_contents($images->path()), $images->getClientOriginalName());
        }
        
        $users = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/dashboard');

        
        $response = $response->post($base_url.'/api/web/create/auditor', [
            'first_name' => $request->first_name,
            'last_name' => $request->last_name,
            'email' => $request->email,
            'password' => $request->password,
            'password_confirmation' => $request->password,
            'created_by' => $users['data']['profile']['id'],
            'company_id' => $request->company_id,
            'status' => '1',
            'time_zone' => $request->time_zone,
            'job_title' => $request->job_title,
        ]);


            if ($response->status() === 200) {

            $responseData = $response->json();

            return $responseData;

        } else {
            $errorData = $response->json();

            return $errorData;
        }


    }

    public function get_auditor(Request $request){

        $headers = $this->getAuthorizationHeaders();

        $base_url = env('APP_URL');
        
        $response = $response->post($base_url.'/api/web/show/auditor/'+$request->id, [
            'id' => $request->id,
        ]);
        $data = $response->json();

        return $data;

    }

    public function update_auditor(Request $request){

        $images = $request->file('images');
        
        $base_url = env('APP_URL');
        $headers = $this->getAuthorizationHeaders();
        
        $response = Http::withHeaders($headers);
        
        if ($images) {
            $response->attach('images', file_get_contents($images->path()), $images->getClientOriginalName());
        }

        
        $response = $response->post($base_url.'/api/web/update/auditor', [
            'first_name' => $request->first_name,
            'last_name' => $request->last_name,
            'email' => $request->email,
            // 'password' => 'lensaudit',
            // 'password_confirmation' => 'lensaudit',
            'update_by' => $request->id,
            'company_id' => $request->company_id,
            'status' => '1',
            'time_zone' => $request->time_zone,
            'job_title' => $request->job_title,
            'status' => $request->status,
            'id' => $request->id,
        ]);


            if ($response->status() === 200) {

            $responseData = $response->json();

            return $responseData;

        } else {
            $errorData = $response->json();

            return $errorData;
        }


    }

    public function delete_auditor(Request $request){
       
        $base_url = env('APP_URL');
        $headers = $this->getAuthorizationHeaders();
        
        $response = Http::withHeaders($headers);
        
        $response = $response->post($base_url.'/api/web/delete/auditor/'.$request->id, [
            'id' => $request->id,
            'status' => '3',
        ]);

        $data = $response->json();


            if ($response->status() === 200) {

            $responseData = $response->json();

            return $responseData;

        } else {
            $errorData = $response->json();

            return $errorData;
        }


    }

}