<?php

namespace App\Http\Controllers\Dashboard;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

use Illuminate\Support\Facades\Http;
use JWTAuth;
use PHPOpenSourceSaver\JWTAuth\Exceptions\JWTException;
use Illuminate\Support\Facades\Cookie;

class AdminsController extends Controller
{
    public $page_title;
    public function __construct() {
        $this->page_title  = '';
    }
    private function getAuthorizationHeaders()
    {
        $token = Cookie::get('token');
        return [
            'Authorization' => 'Bearer '.$token,
            'Accept' => 'application/json',
        ];
    }
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $base_url = env('APP_URL');

        $headers = $this->getAuthorizationHeaders();
        $users = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/admins');

        // return dd($users);
        return view('pages.admins.index', ['page_title' => 'Admins'],compact('users'));
    }

    public function list()
    {
        $base_url = env('APP_URL');

        $headers = $this->getAuthorizationHeaders();
        $users = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/admins');

        $admins = [
            'data' => $users['data']['admins']
        ];

        return $admins;
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        $base_url = env('APP_URL');
        
        $headers = $this->getAuthorizationHeaders();
        $users = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/admins');
        return view('pages.admins.create', ['page_title' => 'Add Admin'],compact('users'));
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        try{
            $base_url = env('APP_URL');
    
            $first_name = $request->first_name;
            $last_name = $request->last_name;
            $email = $request->email;
            $password = $request->password;
            $status = $request->status;
            $time_zone = $request->time_zone;
            $job_title = $request->job_title;
    
            $headers = $this->getAuthorizationHeaders();
            $response = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/create/admins',[
                'first_name' => $first_name,
                'last_name' => $last_name,
                'email' => $email,
                'password' => $password,
                'status' => $status,
                'time_zone' => $time_zone,
                'job_title' => $job_title,
            ]);
            $result = json_decode((string)$response->getBody(),true);
    
            if($result['status'] == true){
                return redirect()->route('admins')->with('success',$result['message']);
            }else{
                return redirect()->route('create_admins')->with('error',$result['message']);
            }
        }catch(\Exception $e){
            return redirect()->back()->with('error',$result['message']);
        }
    }

    /**
     * Display the specified resource.
     */
    public function show(Request $request)
    {
        $base_url = env('APP_URL');
        
        $headers = $this->getAuthorizationHeaders();
        $users = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/dashboard');

        $id = $request->route('id');
        $view_admins = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/show/admins/'.$id,[
            'id' => $id
        ]);
        $admins_view = $view_admins['data']['admins'];
        return view('pages.admins.update', ['page_title' => 'Update Admin'],compact('users','id','admins_view'));
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request)
    {
        try{
            $base_url = env('APP_URL');
            $headers = $this->getAuthorizationHeaders();
    
            $id = $request->id;
            $first_name = $request->first_name;
            $last_name = $request->last_name;
            $email = $request->email;
            $status = $request->status;
            $time_zone = $request->time_zone;
            $job_title = $request->job_title;
    
            $response = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/update/admins',[
                'id' => $id,
                'first_name' => $first_name,
                'last_name' => $last_name,
                'email' => $email,
                'status' => $status,
                'time_zone' => $time_zone,
                'job_title' => $job_title,
            ]);
            $result = json_decode((string)$response->getBody(),true);
    
            if($result['status'] == true){
                return redirect()->route('admins')->with('success',$result['message']);
            }else{
                return redirect()->route('update_admins',$id)->with('error',$result['message']);
            }
        }catch(\Exception $e){
            return redirect()->back()->with('error',$result['message']);
        }
    }
    
    public function delete(Request $request)
    {
        $base_url = env('APP_URL');
        $headers = $this->getAuthorizationHeaders();

        $id = $request->id;
        $status = $request->status;

        $response = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/delete/admins',[
            'id' => $id,
            'status' => $status,
        ]);
        $result = json_decode((string)$response->getBody(),true);

        if($result['status'] == true){
            return redirect()->route('admins');
        }else{
            return redirect()->route('admins');
        }
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }
}
