<?php

namespace App\Http\Controllers\Dashboard;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

use Illuminate\Support\Facades\Http;
use JWTAuth;
use PHPOpenSourceSaver\JWTAuth\Exceptions\JWTException;
use Illuminate\Support\Facades\Cookie;

class AccountsController extends Controller
{
    public $page_title;
    public function __construct() {
        $this->page_title  = '';
    }
    private function getAuthorizationHeaders()
    {
        $token = Cookie::get('token');
        return [
            'Authorization' => 'Bearer '.$token,
            'Accept' => 'application/json',
        ];
    }

    public function accounts()
    {
        $base_url = env('APP_URL');
        
        $headers = $this->getAuthorizationHeaders();
        $users = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/account');
        
        $profile = $users['data']['accounts'][0];
        

        return view('pages.profile.account', ['page_title' => 'My Account'],compact('users','profile'));
    }
    public function billing()
    {
        $base_url = env('APP_URL');
        
        $headers = $this->getAuthorizationHeaders();
        $users = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/account');
        
        // if(!empty($users['data']['accounts'][0])){
        //     $profile = $users['data']['accounts'][0];
        // }else{
        //     $profile = [];
        // }
        
        $profile = $users['data']['accounts'][0];
        return view('pages.profile.billing', ['page_title' => 'Billing'],compact('users','profile'));
    }
    public function billing_api()
    {
        $base_url = env('APP_URL');
        
        $headers = $this->getAuthorizationHeaders();
        $users = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/account');

        if(!empty($users['data']['billing'])){
            $billing = [
                'data' => $users['data']['billing'],
            ];
        }else{
            $billing = [
                'data' => []
            ];
        }

        return $billing;
    }
    public function notification()
    {
        $base_url = env('APP_URL');
        
        $headers = $this->getAuthorizationHeaders();
        $users = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/account');

        $profile = $users['data']['accounts'][0];

        return view('pages.profile.notification', ['page_title' => 'Notification'],compact('users','profile'));
    }
    public function notification_api()
    {
        $base_url = env('APP_URL');
        
        $headers = $this->getAuthorizationHeaders();
        $users = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/account');
        
        if(!empty($users['data']['notification'])){
            $notification = [
                'data' => $users['data']['notification'],
            ];
        }else{
            $notification = [
                'data' => []
            ];
        }

        return $notification;
    }
    
    public function accountspassword()
    {
        $base_url = env('APP_URL');
        
        $headers = $this->getAuthorizationHeaders();
        $users = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/account');

        $profile = $users['data']['accounts'][0];

        return view('pages.profile.password', ['page_title' => 'Change Password'],compact('users','profile'));
    }
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request)
    {
        try{
            $base_url = env('APP_URL');
            $headers = $this->getAuthorizationHeaders();

            $id = $request->id;
            $first_name = $request->first_name;
            $last_name = $request->last_name;
            $email = $request->email;
            $mobile_no = $request->mobile_no;

            $response = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/update/account',[
                'id' => $id,
                'first_name' => $first_name,
                'last_name' => $last_name,
                'email' => $email,
                'mobile_no' => str_replace(' ', '', $mobile_no),
            ]);
            $result = json_decode((string)$response->getBody(),true);

            if($result['status'] == true){
                return redirect()->route('accounts')->with('success',$result['message']);;
            }else{
                return redirect()->route('accounts')->with('error',$result['message']);
            }
        }catch(\Exception $e){
            return redirect()->back()->with('error',$result['message']);
        }
    }
    
    public function updatepassword(Request $request)
    {
        try{
            $base_url = env('APP_URL');
            $headers = $this->getAuthorizationHeaders();

            $users = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/web/account');
            $profile = $users['data']['accounts'][0];

            $id = $profile['id'];
            $password = $request->password;

            // return dd($id);

            $response = Http::timeout(60)->withHeaders($headers)->post($base_url.'/api/auth/web/change-password',[
                'id' => $id,
                'password' => $password,
            ]);
            $result = json_decode((string)$response->getBody(),true);
            // return dd($result);
            if($result['status'] == true){
                return redirect()->route('accountspassword')->with('success',$result['message']);;
            }else{
                return redirect()->route('accountspassword')->with('error',$result['message']);
            }
        }catch(\Exception $e){
            return redirect()->back()->with('error',$result['message']);
        }
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }
}
