<?php

namespace App\Http\Controllers\Api\Web;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

use App\Models\User;
use App\Models\CompanyDepartment;

use App\Customs\Services\UsersService;
use App\Http\Requests\Dashboard\UpdateUsersRequest;

class WebUsersController extends Controller
{
    public function __construct(private UsersService $service){}
    public function list(){
        $user = auth()->user();
        if($user->role != 1){
            return response()->json([
                'status' => false,
                'message' => 'Your ID doesnt have the right access to this account.',
                'data' => null
            ],401);
        }
        $company = User::where('role', 2)->where('status', '!=',3)->get();

        $company_list = [];
        for($ab = 0; $ab < count($company); $ab++){
            $auditor = User::where('role', 3)->where('created_by', $company[$ab]['id'])->where('status', '!=',3)->get();
            // $assignees = count($auditor);
            $assignees = [];
            for($j = 0; $j < count($auditor); $j++){
                    $assignees[] = [
                        'auditor_id' => $auditor[$j]['user_id'],
                        'auditor_name' => $auditor[$j]['first_name']. ' ' .$auditor[$j]['last_name']
                    ];
            }
            $department = CompanyDepartment::where('created_by', $company[$ab]['id'])->get();
            // $company_department = count($department);
            $company_department = [];
            for($i = 0; $i < count($department); $i++){
                $company_department[] = [
                    'department_id' => $department[$i]['user_id'],
                    'department_name' => $department[$i]['name'],
                    'schedules_start_time' => $department[$i]['schedules_start_time'],
                    'schedules_end_time' => $department[$i]['schedules_end_time']
                ];
            }
            
            $department_first = CompanyDepartment::where('created_by', $company[$ab]['id'])->get()->first();
            if(!empty($department_first)){
                $schedules_start_time = $department_first['schedules_start_time']->format('h:i A');
                $schedules_end_time = $department_first['schedules_end_time']->format('h:i A');
            }else{
                $schedules_start_time = "00:00 AM";
                $schedules_end_time = "00:00 AM";
            }

            $company_list[] = [
                'id' => $company[$ab]['id'],
                'avatar' => $company[$ab]['avatar_img'],
                'company_name' => $company[$ab]['first_name'] .' '. $company[$ab]['last_name'],
                'tags_name' => $company[$ab]['user_id'],
                'company_department' => $company_department,
                'action_assignees' => $assignees,
                'last_modified' => $company[$ab]['updated_at'],
                'schedules_default_time_start' => $schedules_start_time,
                'schedules_default_time_end' => $schedules_end_time,
                'status' => $company[$ab]['status']
            ];
        }

        $companydepartment = CompanyDepartment::where('created_by', $user->id)->get()->count();

        if($company){
            return response()->json([
                'status' => true,
                'message' => 'Users List',
                'data' => [
                    'profile' => [
                        'id' => $user->id,
                        'user_id' => '#'.$user->user_id,
                        'avatar_img' => $user->avatar_img,
                        'name' => ucwords($user->first_name).' '.ucwords($user->last_name),
                        'email' => $user->email,
                        'days' => $user->plan_day_remain,
                        'access_web' => $user->access_web,
                        'status' => $user->status,
                        'role' => $user->role,
                        'permission' => $user->permission,
                        'companydepartment' => $companydepartment,
                        'created' => strtoupper($user->created_at->format('dS M, l')),
                        'last_modified' => strtoupper($user->updated_at->format('dS M, l'))
                    ],
                    'company_list' => $company_list
                ]
            ]);
        }else{
            return response()->json([
                'status' => false,
                'message' => 'Your account data not found',
                'data' => null
            ],401);
        }
    }
    
    public function detail(Request $request){
        $user = auth()->user();
        if($user->role != 1){
            return response()->json([
                'status' => false,
                'message' => 'Your ID doesnt have the right access to this account.',
                'data' => null
            ],401);
        }
        $id = $request->id;
        $company = User::where('role', 2)->where('id', $id)->get();

        $company_list = [];
        for($ab = 0; $ab < count($company); $ab++){
            $auditor = User::where('role', 3)->where('created_by', $company[$ab]['id'])->get();
            $assignees = [];
            for($j = 0; $j < count($auditor); $j++){
                    $assignees[] = [
                        'id' => $auditor[$j]['id'],
                        'auditor_id' => $auditor[$j]['user_id'],
                        'auditor_name' => $auditor[$j]['first_name']. ' ' .$auditor[$j]['last_name'],
                        'auditor_email' => $auditor[$j]['email'],
                        'auditor_audits' => 0,
                        'auditor_date' => $auditor[$j]['updated_at'],
                        'auditor_status' => $auditor[$j]['status'],
                    ];
            }
            $department = CompanyDepartment::where('created_by', $company[$ab]['id'])->get();
            $company_department = [];
            for($i = 0; $i < count($department); $i++){
                $company_department[] = [
                    'id' => $department[$i]['id'],
                    'department_id' => $department[$i]['user_id'],
                    'department_name' => $department[$i]['name'],
                    'department_date' => $department[$i]['updated_at'],
                    'department_status' => $department[$i]['plan_status'],
                    'schedules_start_time' => $department[$i]['schedules_start_time'],
                    'schedules_end_time' => $department[$i]['schedules_end_time']
                ];
            }
            $department_first = CompanyDepartment::where('created_by', $company[$ab]['id'])->get()->first();
            if(!empty($department_first)){
                $schedules_start_time = $department_first['schedules_start_time']->format('h:i A');
                $schedules_end_time = $department_first['schedules_end_time']->format('h:i A');
            }else{
                $schedules_start_time = "00:00 AM";
                $schedules_end_time = "00:00 AM";
            }
            $role = [
                '1' => 'Administrator',
                '2' => 'Company',
                '3' => 'Auditor'
            ];
            $current_plan = [
                '0' => '-',
                '1' => 'Trial',
                '2' => 'Basic'
            ];
            $status_list = [
                '1' => 'Inactive',
                '2' => 'Active',
                '3' => 'Deleted',
            ];
            $company_list[] = [
                'id' => $company[$ab]['id'],
                'avatar' => $company[$ab]['avatar_img'],
                'company_name' => $company[$ab]['first_name'] .' '. $company[$ab]['last_name'],
                'user_id' => $company[$ab]['user_id'],
                'user_email' => $company[$ab]['email'],
                'country_code' => $company[$ab]['country_code'],
                'user_mobile' => $company[$ab]['mobile_no'],
                'user_days' => $company[$ab]['plan_day_remain'],
                'user_role' => $role[$company[$ab]['role']],
                'user_plan' => $current_plan[$company[$ab]['plan_actived']],
                'last_modified' => $company[$ab]['updated_at'],
                'status' => $status_list[$company[$ab]['status']],
                'company_department' => $company_department,
                'action_assignees' => $assignees,
                'schedules_default_time_start' => $schedules_start_time,
                'schedules_default_time_end' => $schedules_end_time
            ];
        }

        $companydepartment = CompanyDepartment::where('created_by', $user->id)->get()->count();

        if($company){
            return response()->json([
                'status' => true,
                'message' => 'Users List',
                'data' => [
                    'profile' => [
                        'id' => $user->id,
                        'user_id' => '#'.$user->user_id,
                        'avatar_img' => $user->avatar_img,
                        'name' => ucwords($user->first_name).' '.ucwords($user->last_name),
                        'email' => $user->email,
                        'days' => $user->plan_day_remain,
                        'access_web' => $user->access_web,
                        'status' => $user->status,
                        'role' => $user->role,
                        'permission' => $user->permission,
                        'companydepartment' => $companydepartment,
                        'created' => strtoupper($user->created_at->format('dS M, l')),
                        'last_modified' => strtoupper($user->updated_at->format('dS M, l'))
                    ],
                    'company_list' => $company_list
                ]
            ]);
        }else{
            return response()->json([
                'status' => false,
                'message' => 'Your account data not found',
                'data' => null
            ],401);
        }
    }
    
    public function update(UpdateUsersRequest $request){
        return $this->service->updateUsers($request->validated());
    }
}
