<?php

namespace App\Http\Controllers\Api\Web;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

use App\Models\User;
use App\Models\Category;
use App\Models\Checklist;
use App\Models\ChecklistQuestion;
use App\Models\ChecklistSection;
use App\Models\CompanyDepartment;

use App\Customs\Services\SectionService;
use App\Http\Requests\Dashboard\CreateSectionRequest;
use App\Http\Requests\Dashboard\UpdateSectionRequest;

class WebSectionController extends Controller
{
    public function __construct(private SectionService $service){}

    public function list(Request $request){
        $user = auth()->user();
        $checklist_id = $request->checklist_id;
        
        if($user->role == "1"){
            $section = ChecklistSection::where('checklist_id', $checklist_id)->where('status', '!=',3)->get();
        }else{
            $section = ChecklistSection::where('created_by', $user->id)->where('checklist_id', $checklist_id)->where('status', '!=',3)->get();
        }
        
        $section_list = [];
        for($ab = 0; $ab < count($section); $ab++){
            $department = User::where('id', $section[$ab]['created_by'])->get()->first();
            $checklist = Checklist::where('id', $section[$ab]['checklist_id'])->get()->first();
            $section_list[] = [
                'id' => $section[$ab]['id'],
                'section_id' => $section[$ab]['section_id'],
                'name' => $section[$ab]['name'],
                // 'checklist_id' => $section[$ab]['checklist_id'],
                // 'checklist_name' => $checklist['name'],
                'created_at' => $section[$ab]['created_at'],
                'updated_at' => $section[$ab]['updated_at'],
                'status' => $section[$ab]['status']
            ];
        }

        $companydepartment = CompanyDepartment::where('created_by', $user->id)->get()->count();

        if($section){
            return response()->json([
                'status' => true,
                    'message' => 'Locations List',
                    'data' => [
                        'profile' => [
                            'id' => $user->id,
                            'user_id' => '#'.$user->user_id,
                            'avatar_img' => $user->avatar_img,
                            'name' => ucwords($user->first_name).' '.ucwords($user->last_name),
                            'email' => $user->email,
                            'days' => $user->plan_day_remain,
                            'access_web' => $user->access_web,
                            'status' => $user->status,
                            'role' => $user->role,
                            'permission' => $user->permission,
                            'companydepartment' => $companydepartment,
                            'created' => strtoupper($user->created_at->format('dS M, l')),
                            'last_modified' => strtoupper($user->updated_at->format('dS M, l'))
                        ],
                        'section_list' => $section_list
                    ]
            ]);
        }else{
            return response()->json([
                'status' => false,
                'message' => 'Your account data not found',
                'data' => null
            ],401);
        }
    }
    public function view(Request $request){
        $user = auth()->user();

        $id = $request->id;

        $section = ChecklistSection::where('id', $id)->get();
        $companydepartment = CompanyDepartment::where('created_by', $user->id)->get()->count();

        if($section){
            return response()->json([
                'status' => true,
                    'message' => 'Checklist Section Show',
                    'data' => [
                        'profile' => [
                            'id' => $user->id,
                            'user_id' => '#'.$user->user_id,
                            'avatar_img' => $user->avatar_img,
                            'name' => ucwords($user->first_name).' '.ucwords($user->last_name),
                            'email' => $user->email,
                            'days' => $user->plan_day_remain,
                            'access_web' => $user->access_web,
                            'status' => $user->status,
                            'role' => $user->role,
                            'permission' => $user->permission,
                            'companydepartment' => $companydepartment,
                            'created' => strtoupper($user->created_at->format('dS M, l')),
                            'last_modified' => strtoupper($user->updated_at->format('dS M, l'))
                        ],
                        'section' => $section
                    ]
            ]);
        }else{
            return response()->json([
                'status' => false,
                'message' => 'Your account data not found',
                'data' => null
            ],401);
        }
    }

    public function create(CreateSectionRequest $request){
        return $this->service->createSection($request->validated());
    }
    public function update(UpdateSectionRequest $request){
        return $this->service->updateSection($request->validated());
    }
}
