<?php

namespace App\Http\Controllers\Api\Web;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

use App\Models\User;
use App\Models\Schedule;
use App\Models\Category;
use App\Models\Locations;
use App\Models\Checklist;
use App\Models\CompanyDepartment;

use App\Customs\Services\SchedulewService;
use App\Http\Requests\Dashboard\UpdateScheduleRequest;
use App\Http\Requests\Dashboard\CreateScheduleRequest;

class WebScheduleController extends Controller
{
    public function __construct(private SchedulewService $service){}

    public function list(){
        $user = auth()->user();

        $schedule = Schedule::where('created_by', $user->id)->get();
        $companydepartment = CompanyDepartment::where('created_by', $user->id)->get()->count();
        
        if(empty(count($schedule))){
            $schedulelist = [];
        }else{
            $schedulelist = [];
            for($i = 0; $i < count($schedule); $i++){
                $user_schedule = User::where('id', $schedule[$i]['auditor_id'])->get()->first();
                $user_location = Locations::where('id', $schedule[$i]['location_id'])->get()->first();
                $user_department = CompanyDepartment::where('id', $schedule[$i]['company_id'])->get()->first();
                $checklist = Checklist::where('id', $schedule[$i]['checklist_id'])->get()->first();
                $reschedule_status = $schedule[$i]['reschedule_status'];
                if(empty($reschedule_status) || $reschedule_status = 0){
                    $schedule_on = $schedule[$i]['schedule_on']->format('dS M, l');
                    $schedule_time = $schedule[$i]['start_time']->format('h:m A').' To '.$schedule[$i]['end_time']->format('h:m A');
                }else{
                    $schedule_on = $schedule[$i]['reschedule_on']->format('dS M, l');
                    $schedule_time = $schedule[$i]['re_start_time']->format('h:m A').' To '.$schedule[$i]['re_end_time']->format('h:m A');
                }

                $total_ques_answered = $schedule[$i]['total_ques_answered'];
                $total_question = $schedule[$i]['total_question'];
                $percent_total = $total_ques_answered / $total_question * 100;
                $percent = round($percent_total, 0);

                $status = [
                    '1' => 'Open',
                    '2' => 'In Progress',
                    '3' => 'Overdue',
                    '4' => 'Completed'
                ];
                $reschedule = [
                    null => 'No',
                    '' => 'No',
                    '0' => 'No',
                    '1' => 'Yes'
                ];
                $schedulelist[] = [
                    'id' => $schedule[$i]['id'],
                    'avatar' => $user_schedule['avatar_img'],
                    'title' => $checklist['name'],
                    'category' => 'Category',
                    'location' => $user_location['name'],
                    'audited_by' => ucwords($user_schedule['first_name']).' '.ucwords($user_schedule['last_name']),
                    'campany_department' => $user_department['name'],
                    'scheduled_on' => $schedule_on,
                    'status' => $schedule[$i]['status'],
                    // 'total_question' => $schedule[$i]['total_question'],
                    // 'total_ques_answered' => $schedule[$i]['total_ques_answered'],
                    'progress' => $percent
                ];
            }
        }

        if($schedule){
            return response()->json([
                'status' => true,
                'message' => 'Schedule',
                'data' => [
                    'profile' => [
                        'id' => $user->id,
                        'user_id' => '#'.$user->user_id,
                        'avatar_img' => $user->avatar_img,
                        'name' => ucwords($user->first_name).' '.ucwords($user->last_name),
                        'email' => $user->email,
                        'days' => $user->plan_day_remain,
                        'access_web' => $user->access_web,
                        'status' => $user->status,
                        'role' => $user->role,
                        'permission' => $user->permission,
                        'companydepartment' => $companydepartment,
                        'created' => strtoupper($user->created_at->format('dS M, l')),
                        'last_modified' => strtoupper($user->updated_at->format('dS M, l'))
                    ],
                    'schedule' => $schedulelist
                ]
            ]);
        }else{
            return response()->json([
                'status' => false,
                'message' => 'Your account data not found',
                'data' => null
            ],401);
        }
    }
    public function create(CreateScheduleRequest $request){
        return $this->service->createSchedule($request->validated());
    }
    public function update(UpdateScheduleRequest $request){
        return $this->service->updateSchedule($request->validated());
    }
    
     public function delete(Request $request){
        // $user = auth()->user();

        $deleteSchedule = Schedule::where('id',$request->id)->update([
            'status' => $request->status,
        ]);
        
        if($deleteSchedule){
            return response()->json([
                'status' => true,
                'message' => 'Schedule has been deleted.'
            ],200);
        }else{
            return response()->json([
                'status' => false,
                'message' => 'Something went wrong.'
            ],401);
        }
    }
}
