<?php

namespace App\Http\Controllers\Api\Web;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

use App\Models\User;
use App\Models\CompanyDepartment;

use App\Customs\Services\RolesService;
use App\Http\Requests\Dashboard\UpdateRolesRequest;

class WebRolesController extends Controller
{
    public function __construct(private RolesService $service){}

    public function list(){
        $user = auth()->user();

        $companydepartment = CompanyDepartment::where('created_by', $user->id)->get()->count();

        $users = User::where('status', '!=',3)->get();
        $administrator = User::where('role', 1)->where('status', '!=',3)->get();
        $administrator_li = [];
        for($i = 0; $i < count($administrator); $i++){
            $administrator_li[] = [
                'id' => $administrator[$i]['user_id'],
                'name' => $administrator[$i]['first_name'].' '.$administrator[$i]['last_name']
            ];
        }

        $company = User::where('role', 2)->where('status', '!=',3)->get();
        $company_li = [];
        for($a = 0; $a < count($company); $a++){
            $company_li[] = [
                'id' => $company[$a]['user_id'],
                'name' => $company[$a]['first_name'].' '.$company[$a]['last_name']
            ];
        }

        $auditor = User::where('role', 3)->where('status', '!=',3)->get();
        $auditor_li = [];
        for($b = 0; $b < count($auditor); $b++){
            $auditor_li[] = [
                'id' => $auditor[$b]['user_id'],
                'name' => $auditor[$b]['first_name']. ' ' .$auditor[$b]['last_name']
            ];
        }

        $users_list = [];
        for($i = 0; $i < count($users); $i++){
            $role = [
                '1' => 'Administrator',
                '2' => 'Company',
                '3' => 'Auditor'
            ];
            $current_plan = [
                '0' => '-',
                '1' => 'Trial',
                '2' => 'Basic'
            ];
            $users_list[] = [
                'id' => $users[$i]['id'],
                'full_name' => $users[$i]['first_name'].' '.$users[$i]['last_name'],
                'role' => $role[$users[$i]['role']],
                'username' => $users[$i]['user_id'],
                'email' => $users[$i]['email'],
                'current_plan' => $current_plan[$users[$i]['plan_actived']],
                'billing' => 'Manual',
                'status' => $users[$i]['status'],
                'avatar' => $users[$i]['avatar_img']
            ];
        }

        if($users_list){
            return response()->json([
                'status' => true,
                'message' => 'Roles & Cancellation',
                'data' => [
                    'profile' => [
                        'id' => $user->id,
                        'user_id' => '#'.$user->user_id,
                        'avatar_img' => $user->avatar_img,
                        'name' => ucwords($user->first_name).' '.ucwords($user->last_name),
                        'email' => $user->email,
                        'days' => $user->plan_day_remain,
                        'access_web' => $user->access_web,
                        'status' => $user->status,
                        'role' => $user->role,
                        'permission' => $user->permission,
                        'companydepartment' => $companydepartment,
                        'created' => strtoupper($user->created_at->format('dS M, l')),
                        'last_modified' => strtoupper($user->updated_at->format('dS M, l')),
                        'administrator' => $administrator->count(),
                        'company' => $company->count(),
                        'auditor' => $auditor->count()
                    ],
                    'administrator' => $administrator_li,
                    'company' => $company_li,
                    'auditor' => $auditor_li,
                    'userslist' => $users_list
                ]
            ]);
        }else{
            return response()->json([
                'status' => false,
                'message' => 'Your account data not found',
                'data' => null
            ],401);
        }
    }

    public function update(UpdateRolesRequest $request){
        return $this->service->updateRoles($request->validated());
    }
}
