<?php

namespace App\Http\Controllers\Api\Web;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

use App\Models\User;
use App\Models\Results;
use App\Models\Category;
use App\Models\Checklist;
use App\Models\CompanyDepartment;

use App\Customs\Services\ResultService;
use App\Http\Requests\Dashboard\CreateResultRequest;
use App\Http\Requests\Dashboard\UpdateResultRequest;
use App\Http\Requests\Dashboard\DeleteResultRequest;

class WebResultController extends Controller
{
    public function __construct(private ResultService $service){}
    public function list(){
        $user = auth()->user();

        $results = Results::where('created_by', $user->id)->where('status', '!=',3)->get();
        $companydepartment = CompanyDepartment::where('created_by', $user->id)->get()->count();

        if(empty(count($results))){
            $resultslist = [];
        }else{
            $resultslist = [];
            for($ab = 0; $ab < count($results); $ab++){
                $checklist = Checklist::where('id', $results[$ab]['checklist_id'])->get()->first();
                $category = Category::where('id', $results[$ab]['category_id'])->get()->first();

                $resultslist[] = [
					'id' => $results[$ab]['id'],
                    'result_id' => $results[$ab]['result_id'],
                    'check_id' => $results[$ab]['checklist_id'],
					'checklist_id' => $checklist['checklist_id'],
                    'checklist_name' => $checklist['name'],
                    'category_id' => $category['category_id'],
                    'category_name' => $category['name'],
					'name' => $results[$ab]['name'],
					'symbols' => $results[$ab]['symbols'],
                    'percentage' => $results[$ab]['percentage'],
                    'color' => $results[$ab]['color'],
					'status' => $results[$ab]['status'],
                    'created_at' => isset($results[$ab]['created_at']) ? ucfirst($results[$ab]['created_at']->format('dS M, l')) : 'N/A',
                    'updated_at' => isset($results[$ab]['updated_at']) ? ucfirst($results[$ab]['updated_at']->format('dS M, l')) : 'N/A',
				];
            }
        }

        if($results){
            return response()->json([
                'status' => true,
                'message' => 'Results',
                'data' => [
                    'profile' => [
                        'id' => $user->id,
                        'user_id' => '#'.$user->user_id,
                        'avatar_img' => $user->avatar_img,
                        'name' => ucwords($user->first_name).' '.ucwords($user->last_name),
                        'email' => $user->email,
                        'days' => $user->plan_day_remain,
                        'access_web' => $user->access_web,
                        'status' => $user->status,
                        'role' => $user->role,
                        'permission' => $user->permission,
                        'companydepartment' => $companydepartment,
                        'created' => ucfirst($user->created_at->format('dS M, l')),
                        'last_modified' => ucfirst($user->updated_at->format('dS M, l'))
                    ],
                    'results' => $resultslist
                ]
            ]);
        }else{
            return response()->json([
                'status' => false,
                'message' => 'Your account data not found',
                'data' => null
            ],401);
        }
    }
    public function view(Request $request){
        $user = auth()->user();
        $id = $request->id;

        $results = Results::where('id', $id)->get();
        $companydepartment = CompanyDepartment::where('created_by', $user->id)->get()->count();

        if($results){
            return response()->json([
                'status' => true,
                    'message' => 'Results Show',
                    'data' => [
                        'profile' => [
                            'id' => $user->id,
                            'user_id' => '#'.$user->user_id,
                            'avatar_img' => $user->avatar_img,
                            'name' => ucwords($user->first_name).' '.ucwords($user->last_name),
                            'email' => $user->email,
                            'days' => $user->plan_day_remain,
                            'access_web' => $user->access_web,
                            'status' => $user->status,
                            'role' => $user->role,
                            'permission' => $user->permission,
                            'companydepartment' => $companydepartment,
                            'created' => strtoupper($user->created_at->format('dS M, l')),
                            'last_modified' => strtoupper($user->updated_at->format('dS M, l'))
                        ],
                        'results' => $results
                    ]
            ]);
        }else{
            return response()->json([
                'status' => false,
                'message' => 'Your account data not found',
                'data' => null
            ],401);
        }
    }

    public function create(CreateResultRequest $request){
        return $this->service->createResult($request->validated());
    }
    public function update(UpdateResultRequest $request){
        return $this->service->updateResult($request->validated());
    }
    public function delete(DeleteResultRequest $request){
        return $this->service->deleteResult($request->validated());
    }
}
