<?php

namespace App\Http\Controllers\Api\Web;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

use App\Models\User;
use App\Models\Schedule;
use App\Models\Locations;
use App\Models\Checklist;
use App\Models\ChecklistSection;
use App\Models\ChecklistQuestion;
use App\Models\AuditReport;
use App\Models\AuditQuestionReport;
use App\Models\CompanyDepartment;
use App\Models\Results;

use App\Customs\Services\ReportsService;
use App\Http\Requests\Dashboard\UpdateReportsRequest;

class WebReportsController extends Controller
{
    public function __construct(private ReportsService $service){}
    public function list(){
        $user = auth()->user();
		
		$audituser = User::where('created_by', $user->id)->get();
		$audituserlist = [];
		for($au = 0; $au < count($audituser); $au++){
			$auditreport = AuditReport::where('created_by', $audituser[$au]['id'])->get();
			$auditreportlist = [];
			for($i = 0; $i < count($auditreport); $i++){
				$auditor = User::where('id', $auditreport[$i]['created_by'])->get()->first();
				$schedule = Schedule::where('id', $auditreport[$i]['schedule_id'])->get()->first();
				$company = CompanyDepartment::where('id', $schedule['company_id'])->get()->first();

				$total_question = ChecklistQuestion::where('checklist_id', $auditreport[$i]['checklist_id'])->get()->count();
				$total_ques_answered = AuditQuestionReport::where('schedule_id', $auditreport[$i]['schedule_id'])->where('checklist_id', $auditreport[$i]['checklist_id'])->get()->count();

				// $status = [
				//     '' => null,
				//     '0' => 'In Progress',
				//     '1' => 'In Review',
				//     '2' => 'Completed',
				//     '3' => 'Rejected'
				// ];

				// $total_ques_answered = 0;
				// $total_question = 0;
				if($total_question != 0){
					$percent_total = $total_ques_answered / $total_question * 100;
					$percent = round($percent_total, 0);
				}else{
					$percent = 0;
				}

				$auditreportlist[] = [
					'id' => $auditreport[$i]['id'],
					'report_id' => $auditreport[$i]['audit_id'],
					'report_name' => $auditreport[$i]['checklist_name'],
					'company_id' => $company['user_id'],
					'company_name' => $company['name'],
					'location' => $auditreport[$i]['location_name'],
					'date' => $auditreport[$i]['audit_date'],
					'submitted_by_id' => $auditor['user_id'],
					'submitted_by_name' => $auditor['first_name'].' '.$auditor['last_name'],
					'status' => $auditreport[$i]['status'],
					'score' => $percent,
				];
			}
			
			$audituserlist[] = $auditreportlist;
		}

        $companydepartment = CompanyDepartment::where('created_by', $user->id)->get()->count();

        if($audituser){
            return response()->json([
                'status' => true,
                    'message' => 'Admins',
                    'data' => [
                        'profile' => [
                            'id' => $user->id,
                            'user_id' => '#'.$user->user_id,
                            'avatar_img' => $user->avatar_img,
                            'name' => ucwords($user->first_name).' '.ucwords($user->last_name),
                            'email' => $user->email,
                            'days' => $user->plan_day_remain,
                            'access_web' => $user->access_web,
                            'status' => $user->status,
                            'role' => $user->role,
                            'permission' => $user->permission,
                            'companydepartment' => $companydepartment,
                            'created' => strtoupper($user->created_at->format('dS M, l')),
                            'last_modified' => strtoupper($user->updated_at->format('dS M, l'))
                        ],
                        'auditreport' => $audituserlist
                    ]
            ]);
        }else{
            return response()->json([
                'status' => false,
                'message' => 'Your account data not found',
                'data' => null
            ],401);
        }
    }
    public function print(Request $request){
        $user = auth()->user();
        $audit_id = $request->audit_id;

        $printreport = AuditReport::where('audit_id', $audit_id)->get();

        $printlist = [];
        for($i = 0; $i < count($printreport); $i++){
            // $category = Category::where('id', $checklist['category_id'])->get()->first();
            // $user_department = CompanyDepartment::where('id', $checklist['company_id'])->get()->first();
            // $checklist_section = ChecklistSection::where('checklist_id', $checklist['id'])->where('status', 1)->get();
            // $checklist_question_total = ChecklistQuestion::where('checklist_id', $checklist['id'])->where('status', 1)->get();
            // $checklist_question_answer = AuditQuestionReport::where('schedule_id', $schedule_id)->where('checklist_id', $checklist['id'])->where('status', 1)->get();
            $auditor = User::where('id', $printreport[$i]['created_by'])->get()->first();
            $schedule = Schedule::where('id', $printreport[$i]['schedule_id'])->get()->first();
            $company = CompanyDepartment::where('id', $schedule['company_id'])->get()->first();
            $total_question = ChecklistQuestion::where('checklist_id', $printreport[$i]['checklist_id'])->get()->count();
            $total_ques_answered = AuditQuestionReport::where('schedule_id', $printreport[$i]['schedule_id'])->where('checklist_id', $printreport[$i]['checklist_id'])->get()->count();

            $user_department = CompanyDepartment::where('id', $schedule['company_id'])->get()->first();
            $checklist_section = ChecklistSection::where('checklist_id', $printreport[$i]['checklist_id'])->get();
            $checklist_question_total = ChecklistQuestion::where('checklist_id', $printreport[$i]['checklist_id'])->get();
            $checklist_question_answer = AuditQuestionReport::where('schedule_id', $printreport[$i]['schedule_id'])->where('checklist_id', $printreport[$i]['checklist_id'])->get();

            $results = Results::where('checklist_id', $printreport[$i]['checklist_id'])->get();

            if($total_question != 0){
                $percent_total = $total_ques_answered / $total_question * 100;
                $percent = round($percent_total, 0);
            }else{
                $percent = 0;
            }

            for($ia = 0; $ia < count($checklist_section); $ia++){
                
                $checklist_question = ChecklistQuestion::where('section_id', '=', $checklist_section[$ia]['id'])->where('checklist_id','=', $printreport[$i]['checklist_id'])->get();
                $checklist_answer = AuditQuestionReport::where('section_id', '=', $checklist_section[$ia]['id'])->where('schedule_id', $printreport[$i]['schedule_id'])->where('checklist_id', $printreport[$i]['checklist_id'])->get();

            //     // $checklist_question->count();
                if(count($checklist_question) == 0){
                    $checklist_questions = null;
                }else{
                    $checklist_questions = [];
                    for($xy = 0; $xy < count($checklist_question); $xy++){
                        $questionanswer = AuditQuestionReport::where('questions_id',$checklist_question[$xy]['id'])->where('schedule_id', $printreport[$i]['schedule_id'])->where('checklist_id', $printreport[$i]['checklist_id'])->get();
						
                        if(count($questionanswer) != 1){
                            $questionanswers = null;
                            $questions_images = null;
                            $questions_comments = null;
                        }else{
                            $questionanswers = $questionanswer[0]['questions_answer'];
                            $questions_images = $questionanswer[0]['questions_image'];
                            $questions_comments = $questionanswer[0]['questions_comment'];
                        }

                        $checklist_questions[] = [
                            'id' => $checklist_question[$xy]['id'],
                            'questions_id' => $checklist_question[$xy]['questions_id'],
                            'title' => $checklist_question[$xy]['title'],
                            'questions_answer' => $questionanswers,
                            'questions_image' => $questions_images,
                            'questions_comment' => $questions_comments,
                            'created_at' => $checklist_question[$xy]['created_at'],
                            'updated_at' => $checklist_question[$xy]['updated_at']
                        ];
                    }
                }

                $section[] =[
                    'section_id' => $checklist_section[$ia]['section_id'],
                    'section_name' => $checklist_section[$ia]['name'],
                    'section_total_question' => $checklist_question->count(),
                    'section_total_answer' => $checklist_answer->count(),
                    'section_question' => $checklist_questions
                ];
            }
            $results_list = [];
            for($r = 0; $r < count($results); $r++){
                $results_list[] =[
                    'name' => $results[$r]['name'],
                    'symbols' => $results[$r]['symbols'],
                    'percentage' => $results[$r]['percentage'],
                    'color' => $results[$r]['color']
                ];
            }

            $printlist[] = [
                'id' => $printreport[$i]['id'],
                'report_id' => $printreport[$i]['audit_id'],
                'report_name' => $printreport[$i]['checklist_name'],
                'company_id' => $company['user_id'],
                'company_name' => $company['name'],
                'location' => $printreport[$i]['location_name'],
                'date' => $printreport[$i]['audit_date'],
                'submitted_by_id' => $auditor['user_id'],
                'submitted_by_name' => $auditor['first_name'].' '.$auditor['last_name'],

                'total_section' => $checklist_section->count(),
                'total_question' => $checklist_question_total->count(),
                'total_answer' => $checklist_question_answer->count(),
                'section' => $section,
                'results' => $results_list,
                
                'signature_image' => asset('storage/app/signature/'.$schedule['schedule_id']).'/'.$printreport[$i]['signature_image'],
                'question_image' => asset('storage/app/question/'.$schedule['schedule_id']).'/',
                'status' => $printreport[$i]['status'],
                'score' => $percent
            ];
        }

        $companydepartment = CompanyDepartment::where('created_by', $user->id)->get()->count();

        if($printreport){
            return response()->json([
                'status' => true,
                    'message' => 'Admins',
                    'data' => [
                        'profile' => [
                            'id' => $user->id,
                            'user_id' => '#'.$user->user_id,
                            'avatar_img' => $user->avatar_img,
                            'name' => ucwords($user->first_name).' '.ucwords($user->last_name),
                            'email' => $user->email,
                            'days' => $user->plan_day_remain,
                            'access_web' => $user->access_web,
                            'status' => $user->status,
                            'role' => $user->role,
                            'permission' => $user->permission,
                            'companydepartment' => $companydepartment,
                            'created' => strtoupper($user->created_at->format('dS M, l')),
                            'last_modified' => strtoupper($user->updated_at->format('dS M, l'))
                        ],
                        'printlist' => $printlist
                    ]
            ]);
        }else{
            return response()->json([
                'status' => false,
                'message' => 'Your account data not found',
                'data' => null
            ],401);
        }

    }
    public function update(UpdateReportsRequest $request){
        return $this->service->updateReports($request->validated());
    }
}
