<?php

namespace App\Http\Controllers\Api\Web;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

use App\Models\User;
use App\Models\Invoice;
use App\Models\CompanyDepartment;

use App\Customs\Services\RenewalService;
use App\Http\Requests\Dashboard\UpdateRenewalRequest;

class WebRenewalController extends Controller
{
    public function __construct(private RenewalService $service){}
    
    public function list(){
        $user = auth()->user();

        $clients = User::where('role', 2)->where('status', '!=',3)->get();
        $companydepartment = CompanyDepartment::where('created_by', $user->id)->get()->count();
        $invoice = Invoice::get();
        // Paid // Unpaid
        $paid = Invoice::where('plan_paided_status', 1)->get();
        $unpaid = Invoice::where('plan_paided_status', 0)->get();
        
        $invoice_list = [];
        for($i = 0; $i < count($clients); $i++){
            $paidlist = Invoice::where('plan_paided_status', 1)->where('created_by', $clients[$i]['id'])->groupBy('created_by')->sum('plan_amount');
            $uppaidlist = Invoice::where('plan_paided_status', 0)->where('created_by', $clients[$i]['id'])->groupBy('created_by')->sum('plan_amount');
            $invoicedetail = Invoice::where('plan_paided_status', 1)->where('created_by', $clients[$i]['id'])->orderBy('id', 'desc')->get();
            
            // $plan_type = Invoice::where('created_by', $clients[$i]['id'])->get()->count();
            $plan_value = Invoice::where('created_by', $clients[$i]['id'])->orderBy('created_at','DESC')->get()->first();
            if($plan_value['billing_end_date'] >= now()){
                $plan_values = Invoice::where('created_by', $clients[$i]['id'])->get()->count();
                if($plan_values > 1){
                    $plan_type = 2;
                }else{
                    $plan_type = 3;
                }
            }else{
                $plan_type = 1;
            }

            $pay_type = [
                '1' => 'Manual - Payment'
            ];
            // 
            $invoice_list[] = [
                'id' => $invoicedetail[0]['id'],
                'invoice_id' => $invoicedetail[0]['invoice_id'],
                'company_id' => $clients[$i]['company_id'],
                'company_avatar' => $clients[$i]['avatar_img'],
                'company_name' => $invoicedetail[0]['company_name'],
                'company_number' => $invoicedetail[0]['company_number'],
                'plan_type' => $plan_type,
                'plan_billing' => $pay_type[$invoicedetail[0]['billing_type']],
                'created_on' => $invoicedetail[0]['created_at'],
                'updated_on' => $invoicedetail[0]['updated_at'],
                'status' => $invoicedetail[0]['status']
            ];
        }

        if($invoice){
            return response()->json([
                'status' => true,
                'message' => 'Renewal & Cancellation',
                'data' => [
                    'profile' => [
                        'id' => $user->id,
                        'user_id' => '#'.$user->user_id,
                        'avatar_img' => $user->avatar_img,
                        'name' => ucwords($user->first_name).' '.ucwords($user->last_name),
                        'email' => $user->email,
                        'days' => $user->plan_day_remain,
                        'access_web' => $user->access_web,
                        'status' => $user->status,
                        'role' => $user->role,
                        'permission' => $user->permission,
                        'companydepartment' => $companydepartment,
                        'created' => strtoupper($user->created_at->format('dS M, l')),
                        'last_modified' => strtoupper($user->updated_at->format('dS M, l')),
                        'invoices' => $invoice->count(),
                        'clients' => $clients->count(),
                        'paid' => $paid->sum('plan_amount'),
                        'unpaid' => $unpaid->sum('plan_amount')
                    ],
                    'invoice' => $invoice_list
                ]
            ]);
        }else{
            return response()->json([
                'status' => false,
                'message' => 'Your account data not found',
                'data' => null
            ],401);
        }
    }
    
    public function update(UpdateRenewalRequest $request){
        return $this->service->updateRenewal($request->validated());
    }
}
