<?php

namespace App\Http\Controllers\Api\Web;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

use App\Models\User;
use App\Models\Category;
use App\Models\Checklist;
use App\Models\ChecklistQuestion;
use App\Models\ChecklistSection;
use App\Models\CompanyDepartment;

use App\Customs\Services\QuestionsService;
use App\Http\Requests\Dashboard\CreateQuestionsRequest;
use App\Http\Requests\Dashboard\UpdateQuestionsRequest;
use App\Http\Requests\Dashboard\EditQuestionsRequest;

class WebQuestionsController extends Controller
{
    public function __construct(private QuestionsService $service){}

    public function list(Request $request){
        $user = auth()->user();
        $checklist_id = $request->checklist_id;

        
        if($user->role == "1"){
            $question = ChecklistQuestion::where('checklist_id', $checklist_id)->where('status', '!=',3)->get();
        }else{
            $question = ChecklistQuestion::where('created_by', $user->id)->where('checklist_id', $checklist_id)->where('status', '!=',3)->get();
        }
        
        $question_list = [];
        for($ab = 0; $ab < count($question); $ab++){
            $department = User::where('id', $question[$ab]['created_by'])->get()->first();
            $checklist = Checklist::where('id', $question[$ab]['checklist_id'])->get()->first();
            $question_list[] = [
                'id' => $question[$ab]['id'],
                'question_id' => $question[$ab]['questions_id'],
                'name' => $question[$ab]['title'],
                // 'checklist_id' => $section[$ab]['checklist_id'],
                // 'checklist_name' => $checklist['name'],
                'created_at' => $question[$ab]['created_at'],
                'updated_at' => $question[$ab]['updated_at'],
                'status' => $question[$ab]['status']
            ];
        }

        $companydepartment = CompanyDepartment::where('created_by', $user->id)->get()->count();

        if($question){
            return response()->json([
                'status' => true,
                    'message' => 'Locations List',
                    'data' => [
                        'profile' => [
                            'id' => $user->id,
                            'user_id' => '#'.$user->user_id,
                            'avatar_img' => $user->avatar_img,
                            'name' => ucwords($user->first_name).' '.ucwords($user->last_name),
                            'email' => $user->email,
                            'days' => $user->plan_day_remain,
                            'access_web' => $user->access_web,
                            'status' => $user->status,
                            'role' => $user->role,
                            'permission' => $user->permission,
                            'companydepartment' => $companydepartment,
                            'created' => strtoupper($user->created_at->format('dS M, l')),
                            'last_modified' => strtoupper($user->updated_at->format('dS M, l'))
                        ],
                        'question_list' => $question_list
                    ]
            ]);
        }else{
            return response()->json([
                'status' => false,
                'message' => 'Your account data not found',
                'data' => null
            ],401);
        }
    }

    public function view(Request $request){
        $user = auth()->user();
        $id = $request->id;

        $question = ChecklistQuestion::where('id', $id)->get();
        $companydepartment = CompanyDepartment::where('created_by', $user->id)->get()->count();

        if($question){
            return response()->json([
                'status' => true,
                    'message' => 'Checklist Question Show',
                    'data' => [
                        'profile' => [
                            'id' => $user->id,
                            'user_id' => '#'.$user->user_id,
                            'avatar_img' => $user->avatar_img,
                            'name' => ucwords($user->first_name).' '.ucwords($user->last_name),
                            'email' => $user->email,
                            'days' => $user->plan_day_remain,
                            'access_web' => $user->access_web,
                            'status' => $user->status,
                            'role' => $user->role,
                            'permission' => $user->permission,
                            'companydepartment' => $companydepartment,
                            'created' => strtoupper($user->created_at->format('dS M, l')),
                            'last_modified' => strtoupper($user->updated_at->format('dS M, l'))
                        ],
                        'question' => $question
                    ]
            ]);
        }else{
            return response()->json([
                'status' => false,
                'message' => 'Your account data not found',
                'data' => null
            ],401);
        }
    }
    
    public function create(CreateQuestionsRequest $request){
        return $this->service->createQuestions($request->validated());
    }
    
    public function edit(EditQuestionsRequest $request){
        return $this->service->editQuestions($request->validated());
    }

    public function update(UpdateQuestionsRequest $request){
        return $this->service->updateQuestions($request->validated());
    }

    public function delete(DeleteQuestionsRequest $request){
        return $this->service->deleteQuestions($request->validated());
    }
}
