<?php

namespace App\Http\Controllers\Api\Web;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

use App\Models\User;
use App\Models\Plans;
use App\Models\CompanyDepartment;

use App\Customs\Services\PlansService;
use App\Http\Requests\Dashboard\UpdatePlansRequest;

class WebPlansController extends Controller
{
    public function __construct(private PlansService $service){}

    public function list(){
        $user = auth()->user();

        $plans = Plans::all();
        $companydepartment = CompanyDepartment::where('created_by', $user->id)->get()->count();

        $planslist = [];
        for($i = 0; $i < count($plans); $i++){
            $price_yearly = $plans[$i]['amount'] * 12;
            $planslist[] = [
                'id' => $plans[$i]['id'],
                'plan_id' => 'PI-'.$plans[$i]['id'],
                'plan_name' => $plans[$i]['title'],
                'plan_days' => $plans[$i]['days'],
                'price_monthly' => $plans[$i]['amount'],
                'price_yearly' => $price_yearly,
                'plan_type' => '',
                'plan_brief' => $plans[$i]['subtitle'],
                'plan_feature_list' => $plans[$i]['feature'],
                'created_on' => $plans[$i]['created_at']->format('d M Y'),
                'status' => $plans[$i]['status']
            ];
        }

        if($plans){
            return response()->json([
                'status' => true,
                    'message' => 'Plans',
                    'data' => [
                        'profile' => [
                            'id' => $user->id,
                            'user_id' => '#'.$user->user_id,
                            'avatar_img' => $user->avatar_img,
                            'name' => ucwords($user->first_name).' '.ucwords($user->last_name),
                            'email' => $user->email,
                            'days' => $user->plan_day_remain,
                            'access_web' => $user->access_web,
                            'status' => $user->status,
                            'role' => $user->role,
                            'permission' => $user->permission,
                            'companydepartment' => $companydepartment,
                            'created' => strtoupper($user->created_at->format('dS M, l')),
                            'last_modified' => strtoupper($user->updated_at->format('dS M, l'))
                        ],
                        'plans' => $planslist
                    ]
            ]);
        }else{
            return response()->json([
                'status' => false,
                'message' => 'Your account data not found',
                'data' => null
            ],401);
        }
    }
    public function view(Request $request){
        $user = auth()->user();

        $id = $request->id;

        $plans = Plans::where('id', $id)->get();
        $companydepartment = CompanyDepartment::where('created_by', $user->id)->get()->count();

        if($plans){
            return response()->json([
                'status' => true,
                    'message' => 'Plans',
                    'data' => [
                        'profile' => [
                            'id' => $user->id,
                            'user_id' => '#'.$user->user_id,
                            'avatar_img' => $user->avatar_img,
                            'name' => ucwords($user->first_name).' '.ucwords($user->last_name),
                            'email' => $user->email,
                            'days' => $user->plan_day_remain,
                            'access_web' => $user->access_web,
                            'status' => $user->status,
                            'role' => $user->role,
                            'permission' => $user->permission,
                            'companydepartment' => $companydepartment,
                            'created' => strtoupper($user->created_at->format('dS M, l')),
                            'last_modified' => strtoupper($user->updated_at->format('dS M, l'))
                        ],
                        'plans' => $plans
                    ]
            ]);
        }else{
            return response()->json([
                'status' => false,
                'message' => 'Your account data not found',
                'data' => null
            ],401);
        }
    }
    public function update(UpdatePlansRequest $request){
        return $this->service->updatePlans($request->validated());
    }
}
