<?php

namespace App\Http\Controllers\Api\Web;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

use App\Models\User;
use App\Models\Locations;
use App\Models\CompanyDepartment;

use App\Customs\Services\LocationsService;
use App\Http\Requests\Dashboard\UpdateLocationsRequest;
use App\Http\Requests\Dashboard\CreateLocationsRequest;

class WebLocationsController extends Controller
{
    public function __construct(private LocationsService $service){}

    public function list(){
        $user = auth()->user();

        $locations = Locations::where('created_by', $user->id)->where('status', '!=',3)->get();
        $locations_list = [];
        for($ab = 0; $ab < count($locations); $ab++){
            $department = CompanyDepartment::where('id', $locations[$ab]['company_id'])->get()->first();
            $locations_list[] = [
                'id' => $locations[$ab]['id'],
                'avatar' => null,
                'locations_code' => $locations[$ab]['location_id'],
                'location' => $locations[$ab]['name'],
                'company' => $department['name'],
                'address_full' => $locations[$ab]['address'],
                'time_zone' => $locations[$ab]['time_zone'],
                'pincode_postcode' => $locations[$ab]['postcode'],
                'status' => $locations[$ab]['status']
            ];
        }

        $companydepartment = CompanyDepartment::where('created_by', $user->id)->get()->count();

        if($locations){
            return response()->json([
                'status' => true,
                    'message' => 'Locations List',
                    'data' => [
                        'profile' => [
                            'id' => $user->id,
                            'user_id' => '#'.$user->user_id,
                            'avatar_img' => $user->avatar_img,
                            'name' => ucwords($user->first_name).' '.ucwords($user->last_name),
                            'email' => $user->email,
                            'days' => $user->plan_day_remain,
                            'access_web' => $user->access_web,
                            'status' => $user->status,
                            'role' => $user->role,
                            'permission' => $user->permission,
                            'companydepartment' => $companydepartment,
                            'created' => strtoupper($user->created_at->format('dS M, l')),
                            'last_modified' => strtoupper($user->updated_at->format('dS M, l'))
                        ],
                        'locations_list' => $locations_list
                    ]
            ]);
        }else{
            return response()->json([
                'status' => false,
                'message' => 'Your account data not found',
                'data' => null
            ],401);
        }
    }
    public function view(Request $request){
        $user = auth()->user();

        $id = $request->id;

        $locations = Locations::where('id', $id)->get();
        $companydepartment = CompanyDepartment::where('created_by', $user->id)->get()->count();

        if($locations){
            return response()->json([
                'status' => true,
                    'message' => 'Location Show',
                    'data' => [
                        'profile' => [
                            'id' => $user->id,
                            'user_id' => '#'.$user->user_id,
                            'avatar_img' => $user->avatar_img,
                            'name' => ucwords($user->first_name).' '.ucwords($user->last_name),
                            'email' => $user->email,
                            'days' => $user->plan_day_remain,
                            'access_web' => $user->access_web,
                            'status' => $user->status,
                            'role' => $user->role,
                            'permission' => $user->permission,
                            'companydepartment' => $companydepartment,
                            'created' => strtoupper($user->created_at->format('dS M, l')),
                            'last_modified' => strtoupper($user->updated_at->format('dS M, l'))
                        ],
                        'locations' => $locations
                    ]
            ]);
        }else{
            return response()->json([
                'status' => false,
                'message' => 'Your account data not found',
                'data' => null
            ],401);
        }
    }
    
     public function delete(Request $request){
        // $user = auth()->user();

        $deletelocation = Locations::where('id',$request->id)->update([
            'status' => $request->status,
        ]);
        
        if($deletelocation){
            return response()->json([
                'status' => true,
                'message' => 'Location has been deleted.'
            ],200);
        }else{
            return response()->json([
                'status' => false,
                'message' => 'Something went wrong.'
            ],401);
        }
    }

    public function create(CreateLocationsRequest $request){
        return $this->service->createLocations($request->validated());
    }
    public function update(UpdateLocationsRequest $request){
        return $this->service->updateLocations($request->validated());
    }
}
