<?php

namespace App\Http\Controllers\Api\Web;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

use App\Models\User;
use App\Models\Invoice;
use App\Models\CompanyDepartment;

use App\Customs\Services\InvoiceService;
use App\Http\Requests\Dashboard\UpdateInvoiceRequest;

class WebInvoiceController extends Controller
{
    public function __construct(private InvoiceService $service){}

    public function list(){
        $user = auth()->user();

        $clients = User::where('role', 2)->get();
        $companydepartment = CompanyDepartment::where('created_by', $user->id)->get()->count();
        $invoice = Invoice::get();
        // Paid // Unpaid
        $paid = Invoice::where('plan_paided_status', 1)->get();
        $unpaid = Invoice::where('plan_paided_status', 0)->get();
        // return response()->json($clients);
        $invoice_list = [];
        for($i = 0; $i < count($clients); $i++){
            $paidlist = Invoice::where('plan_paided_status', 1)->where('created_by', $clients[$i]['id'])->groupBy('created_by')->sum('plan_amount');
            $uppaidlist = Invoice::where('plan_paided_status', 0)->where('created_by', $clients[$i]['id'])->groupBy('created_by')->sum('plan_amount');
            $invoicedetail = Invoice::where('plan_paided_status', 1)->where('created_by', $clients[$i]['id'])->orderBy('id', 'desc')->get();
            
            $invoice_list[] = [
                'invoice_id' => $invoicedetail[0]['invoice_id'],
                'issued_date' => $invoicedetail[0]['plan_issued_date'],
                'company_id' => $invoicedetail[0]['company_id'],
                'company_name' => $invoicedetail[0]['company_name'],
                'company_number' => $invoicedetail[0]['company_number'],
                'total' => $paidlist,
                'avatar_image' => $clients[$i]['avatar_img'],
                'invoice_status' => $invoicedetail[0]['plan_paided_status'],
                'balance' => $uppaidlist,
                'created_at' => $invoicedetail[0]['created_at'],
                "action" =>  1
            ];
        }

        if($invoice){
            return response()->json([
                'status' => true,
                'message' => 'Invoice',
                'data' => [
                    'profile' => [
                        'id' => $user->id,
                        'user_id' => '#'.$user->user_id,
                        'avatar_img' => $user->avatar_img,
                        'name' => ucwords($user->first_name).' '.ucwords($user->last_name),
                        'email' => $user->email,
                        'days' => $user->plan_day_remain,
                        'access_web' => $user->access_web,
                        'status' => $user->status,
                        'role' => $user->role,
                        'permission' => $user->permission,
                        'companydepartment' => $companydepartment,
                        'created' => strtoupper($user->created_at->format('dS M, l')),
                        'last_modified' => strtoupper($user->updated_at->format('dS M, l')),
                        'invoices' => $invoice->count(),
                        'clients' => $clients->count(),
                        'paid' => $paid->sum('plan_amount'),
                        'unpaid' => $unpaid->sum('plan_amount')
                    ],
                    'invoice' => $invoice_list
                ]
            ]);
        }else{
            return response()->json([
                'status' => false,
                'message' => 'Your account data not found',
                'data' => null
            ],401);
        }
    }

    public function view(Request $request){
        $user = auth()->user();

        $id = $request->id;

        $invoice = Invoice::where('created_by', $id)->get();
        $companydepartment = CompanyDepartment::where('created_by', $user->id)->get()->count();
        $company = User::where('id', $id)->get()->first();

        // Paid // Unpaid
        $paid = Invoice::where('created_by', $id)->where('plan_paided_status', 1)->get();
        $unpaid = Invoice::where('created_by', $id)->where('plan_paided_status', 0)->get();

        $invoice_list = [];
        for($i = 0; $i < count($invoice); $i++){
            $paidlist = Invoice::select('plan_amount')->where('plan_paided_status', 1)->where('id', $invoice[$i]['id'])->get()->first();
            $uppaidlist = Invoice::select('plan_amount')->where('plan_paided_status', 0)->where('id', $invoice[$i]['id'])->get()->first();

            if(is_null($paidlist) == true){
                $paidlists = 0;
            }else{
                $paidlists = $paidlist['plan_amount'];
            }
            if(is_null($uppaidlist) == true){
                $uppaidlists = 0;
            }else{
                $uppaidlists = $uppaidlist['plan_amount'];
            }

            $invoice_list[] = [
                'invoice_id' => $invoice[$i]['invoice_id'],
                'issued_date' => $invoice[$i]['plan_issued_date'],
                'company_id' => $invoice[$i]['company_id'],
                'company_name' => $invoice[$i]['company_name'],
                'company_number' => $invoice[$i]['company_number'],
                'total' => $paidlists,
                'avatar_image' => null,
                'invoice_status' => $invoice[$i]['plan_paided_status'],
                'balance' => $uppaidlists,
                'created_at' => $invoice[$i]['created_at'],
                "action" =>  1
            ];
        }

        if($invoice){
            return response()->json([
                'status' => true,
                    'message' => 'Category',
                    'data' => [
                        'profile' => [
                            'id' => $user->id,
                            'user_id' => '#'.$user->user_id,
                            'avatar_img' => $user->avatar_img,
                            'name' => ucwords($user->first_name).' '.ucwords($user->last_name),
                            'email' => $user->email,
                            'days' => $user->plan_day_remain,
                            'access_web' => $user->access_web,
                            'status' => $user->status,
                            'role' => $user->role,
                            'permission' => $user->permission,
                            'companydepartment' => $companydepartment,
                            'created' => strtoupper($user->created_at->format('dS M, l')),
                            'last_modified' => strtoupper($user->updated_at->format('dS M, l')),
                            'invoices' => $invoice->count(),
                            'paid' => $paid->sum('plan_amount'),
                            'unpaid' => $unpaid->sum('plan_amount')
                        ],
                        'company_profile' => [
                            'company_avatar' => $company['avatar_img'],
                            'company_id' => $company['user_id'],
                            'company_name' => $company['first_name'].' '.$company['last_name'],
                            'company_number' => $company['mobile_no'],
                            'invoice' => $invoice_list
                        ]
                    ]
            ]);
        }else{
            return response()->json([
                'status' => false,
                'message' => 'Your account data not found',
                'data' => null
            ],401);
        }
    }

    public function prints(Request $request){
        $user = auth()->user();
        $id = $request->id;

        $invoice = Invoice::where('invoice_id', $id)->get();

        $invoice_list = [];
        if(count($invoice) != null){
            $tax = 0;
            $total = $invoice[0]['plan_amount'] + $tax;
            $plan_name = [
                '1' => 'Trial',
                '2' => 'Basic'
            ];
            $company = User::where('id', $invoice[0]['company_id'])->get()->first();
            $invoice_list[] = [
                'invoice_id' => $invoice[0]['invoice_id'],
                'issued_date' => $invoice[0]['plan_issued_date'],
                'due_date' => $invoice[0]['plan_issued_date'],
                'bank_name' => 'Bank Name',
                'bank_trans' => $invoice[0]['transaction_id'],
                'bank_country' => 'USA',
                'company_name' => $invoice[0]['company_name'],
                'company_number' => $invoice[0]['company_number'],
                'company_email' => $company['email'],
                'company_id' => '#'.$company['user_id'],
                'plan_actived' => $invoice[0]['plan_actived'],
                'plan_name' => $plan_name[$invoice[0]['plan_actived']],
                'plan_desc' => '-',
                'plan_cost' => 0,
                'plan_price' => $invoice[0]['plan_amount'],
                'subtotal' => $invoice[0]['plan_amount'],
                'tax' => $tax,
                'total' => $total,
            ];
        }

        if(count($invoice) != null){
            return response()->json([
                'status' => true,
                    'message' => 'Print Invoice',
                    'data' => $invoice_list
            ]);
        }else{
            return response()->json([
                'status' => false,
                'message' => 'Your account data not found',
                'data' => null
            ],401);
        }

    }

    public function update(UpdateInvoiceRequest $request){
        return $this->service->updateInvoice($request->validated());
    }
}
