<?php

namespace App\Http\Controllers\Api\Web;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

use App\Models\User;
use App\Models\Schedule;
use App\Models\Locations;
use App\Models\Checklist;
use App\Models\AuditReport;
use App\Models\AuditQuestionReport;
use App\Models\CompanyDepartment;

class WebImagereportController extends Controller
{
    public function list(){
        $user = auth()->user();
		
		$audituser = User::where('created_by', $user->id)->get();
		$audituserlist = [];
		for($au = 0; $au < count($audituser); $au++){
			$imagereport = AuditReport::where('created_by', $audituser[$au]['id'])->where('status', '!=',3)->get();
			$imagereportlist = [];
			for($i = 0; $i < count($imagereport); $i++){
				$image_list = AuditQuestionReport::where('audit_id', $imagereport[$i]['audit_id'])->where('questions_image', '!=', null)->get();

				$imagerlist = [];
				for($j = 0; $j < count($image_list); $j++){
					$imagerlist[] =  $image_list[$j]['questions_image'];
				}
				if($imagerlist != null){
					$arrayStr = implode(",", array_map(function ($subArray) {
						return implode(',', array_map(function ($element) {
							return '"' . $element . '"';
						}, $subArray));
					}, $imagerlist));
					$array = explode(',', $arrayStr);
					$arrayimage = array_map(function($item) {
						return str_replace('"', '', $item);
					}, $array);
				}else{
					$arrayimage = null;
				}

				$imagereportlist[] = [
					'id' => $imagereport[$i]['id'],
					'audit_id' => $imagereport[$i]['audit_id'],
					'image_list' => $arrayimage,
					'created_at' => $imagereport[$i]['created_at'],
					'updated_at' => $imagereport[$i]['updated_at']
				];
			}
			
			$audituserlist[] = $imagereportlist;
		}
        
        
        $companydepartment = CompanyDepartment::where('created_by', $user->id)->get()->count();

        if($audituser){
            return response()->json([
                'status' => true,
                    'message' => 'Admins',
                    'data' => [
                        'profile' => [
                            'id' => $user->id,
                            'user_id' => '#'.$user->user_id,
                            'avatar_img' => $user->avatar_img,
                            'name' => ucwords($user->first_name).' '.ucwords($user->last_name),
                            'email' => $user->email,
                            'days' => $user->plan_day_remain,
                            'access_web' => $user->access_web,
                            'status' => $user->status,
                            'role' => $user->role,
                            'permission' => $user->permission,
                            'companydepartment' => $companydepartment,
                            'created' => strtoupper($user->created_at->format('dS M, l')),
                            'last_modified' => strtoupper($user->updated_at->format('dS M, l'))
                        ],
                        'imagereport' => $audituserlist
                    ]
            ]);
        }else{
            return response()->json([
                'status' => false,
                'message' => 'Your account data not found',
                'data' => null
            ],401);
        }
    }

    public function view(Request $request){
        $user = auth()->user();
        $audit_id = $request->audit_id;

        $imagereport = AuditReport::where('audit_id', $audit_id)->get();

        $imagereportlist = [];
        for($i = 0; $i < count($imagereport); $i++){
            $image_list = AuditQuestionReport::where('audit_id', $imagereport[$i]['audit_id'])->where('questions_image', '!=', null)->get();
            $schedule = Schedule::where('id', $imagereport[$i]['schedule_id'])->get()->first();
            $imagerlist = [];
            for($j = 0; $j < count($image_list); $j++){
                $imagerlist[] =  $image_list[$j]['questions_image'];
            }
			if(!empty($imagerlist)){
				if($imagerlist[0] != null){
					$arrayStr = implode(",", array_map(function ($subArray) {
						return implode(',', array_map(function ($element) {
							return '"' . $element . '"';
						}, $subArray));
					}, $imagerlist));
					$array = explode(',', $arrayStr);
					$arrayimage = array_map(function($item) {
						return str_replace('"', '', $item);
					}, $array);
				}else{
					$arrayimage = null;
				}
			}else{
				$arrayimage = null;
			}
            
            

            $imagereportlist[] = [
                'id' => $imagereport[$i]['id'],
                'audit_id' => $imagereport[$i]['audit_id'],
                'image_url' => asset('storage/app/question/'.$schedule['schedule_id']).'/',
                'image_list' => $arrayimage,
                'created_at' => $imagereport[$i]['created_at'],
                'updated_at' => $imagereport[$i]['updated_at']
            ];
        }
        
        $companydepartment = CompanyDepartment::where('created_by', $user->id)->get()->count();

        if($imagereport){
            return response()->json([
                'status' => true,
                    'message' => 'Admins',
                    'data' => [
                        'profile' => [
                            'id' => $user->id,
                            'user_id' => '#'.$user->user_id,
                            'avatar_img' => $user->avatar_img,
                            'name' => ucwords($user->first_name).' '.ucwords($user->last_name),
                            'email' => $user->email,
                            'days' => $user->plan_day_remain,
                            'access_web' => $user->access_web,
                            'status' => $user->status,
                            'role' => $user->role,
                            'permission' => $user->permission,
                            'companydepartment' => $companydepartment,
                            'created' => strtoupper($user->created_at->format('dS M, l')),
                            'last_modified' => strtoupper($user->updated_at->format('dS M, l'))
                        ],
                        'imagereport' => $imagereportlist
                    ]
            ]);
        }else{
            return response()->json([
                'status' => false,
                'message' => 'Your account data not found',
                'data' => null
            ],401);
        }
    }
}
