<?php

namespace App\Http\Controllers\Api\Web;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\User;
use App\Models\Gateway;
use App\Models\CompanyDepartment;
use Illuminate\Support\Facades\Crypt;
use Illuminate\Support\Facades\Validator;

class WebGatewayController extends Controller
{

    public function list(){
        $user = auth()->user();

        
        $gateway = Gateway::get();
        $companydepartment = CompanyDepartment::where('created_by', $user->id)->get()->count();


        if($gateway){
            return response()->json([
                'status' => true,
                    'message' => 'Gateway',
                    'data' => [
                        'profile' => [
                            'id' => $user->id,
                            'user_id' => '#'.$user->user_id,
                            'avatar_img' => $user->avatar_img,
                            'name' => ucwords($user->first_name).' '.ucwords($user->last_name),
                            'email' => $user->email,
                            'days' => $user->plan_day_remain,
                            'access_web' => $user->access_web,
                            'status' => $user->status,
                            'role' => $user->role,
                            'permission' => $user->permission,
                            'companydepartment' => $companydepartment,
                            'created' => strtoupper($user->created_at->format('dS M, l')),
                            'last_modified' => strtoupper($user->updated_at->format('dS M, l'))
                        ],
                        'gateway' => $gateway
                    ]
            ]);
        }else{
            return response()->json([
                'status' => false,
                'message' => 'Your account data not found',
                'data' => null
            ],401);
        }
    }
   
    public function view(Request $request){
        $user = auth()->user();

        // $id = $request->id;
        // $id = Crypt::decrypt($request->id);
        $id = $request->id;

        $gateway = Gateway::where('id', $id)->get();
        $companydepartment = CompanyDepartment::where('created_by', $user->id)->get()->count();

        if($gateway){
            return response()->json([
                'status' => true,
                    'message' => 'Gateway',
                    'data' => [
                        'profile' => [
                            'id' => $user->id,
                            'user_id' => '#'.$user->user_id,
                            'avatar_img' => $user->avatar_img,
                            'name' => ucwords($user->first_name).' '.ucwords($user->last_name),
                            'email' => $user->email,
                            'days' => $user->plan_day_remain,
                            'access_web' => $user->access_web,
                            'status' => $user->status,
                            'role' => $user->role,
                            'permission' => $user->permission,
                            'companydepartment' => $companydepartment,
                            'created' => strtoupper($user->created_at->format('dS M, l')),
                            'last_modified' => strtoupper($user->updated_at->format('dS M, l'))
                        ],
                        'gateway' => $gateway
                    ]
            ]);
        }else{
            return response()->json([
                'status' => false,
                'message' => 'Your account data not found',
                'data' => null
            ],401);
        }
    }

    public function update(Request $request){
        // $user = auth()->user();

        $validator = Validator::make($request->all(), [
            'key_value' => 'required',
            'secret_value' => 'required',
            'id' => 'required',
        ]);

        if ($validator->fails()) {
            // return response()->json(['errors' => $validator->errors()], 422);
            return response()->json([
                'status' => false,
                'errors' => $validator->errors()
            ],200);
        }

        $gateway = Gateway::where('id',$request->id)->update([
            'key_value' => $request->key_value,
            'secret_value' => $request->secret_value,
            'updated_at' => now()
        ]);
        
        if($gateway){
            return response()->json([
                'status' => true,
                'message' => 'Payment Gateway Key & Secret Id has been updated.'
            ],200);
        }else{
            return response()->json([
                'status' => false,
                'message' => 'Something went wrong.'
            ],401);
        }
    }

}
