<?php

namespace App\Http\Controllers\Api\Web;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

use App\Models\User;
use App\Models\Feedback;
use App\Models\CompanyDepartment;

use App\Customs\Services\FeedbackService;
use App\Http\Requests\Dashboard\UpdateFeedbackRequest;
use App\Http\Requests\Dashboard\CreateFeedbackRequest;

class WebFeedbackController extends Controller
{
    public function __construct(private FeedbackService $service){}

    public function list(){
        $user = auth()->user();

        if($user->role == 1){
            $feedback = Feedback::all();
        }else{
            $feedback = Feedback::where('created_by', $user->id)->get();
        }
        
        $companydepartment = CompanyDepartment::where('created_by', $user->id)->get()->count();

        $feedback_list = [];
        for($i = 0; $i < count($feedback); $i++){
            $company = User::where('id', $feedback[$i]['user_id'])->get()->first();
            $users = User::where('id', $feedback[$i]['updated_by'])->get()->first();
            
            if(!empty($company)){
                $company_avatar = $company['avatar_img'];
                $company_id = $company['user_id'];
                $company_name = $company['first_name'].' '.$company['last_name'];
                $company_number = '+917 '. $company['mobile_no'];
            }else{
                $company_avatar = null;
                $company_id = '';
                $company_name = 'N/A';
                $company_number = '';
            }

            if(!empty($users)){
                $closed_avatar = $users['avatar_img'];
                $closed_name = $users['first_name'].' '.$users['last_name'];
                $closed_role = $users['role'];
            }else{
                $closed_avatar = null;
                $closed_name = 'N/A';
                $closed_role = null;
            }

            $issue_type = [
                '1' => 'Audit Related Problems',
                '2' => 'Schedule Related Problems',
                '3' => 'Notification',
                '4' => 'Software Installation and Update Errors',
                '5' => 'License and Subscription Management',
                '6' => 'Plan Renewal & Cancellation',
                '7' => 'Form builder Problems'
            ];
            $role = [
                null => '',
                '1' => 'Administrator',
                '2' => 'Company',
                '3' => 'Auditor'
            ];
            
            $feedback_list[] = [
                'id' => $feedback[$i]['id'],
                'ticket_id' => $feedback[$i]['ticket_id'],
                'ticket_status' => $feedback[$i]['status'],
                'issue_type' => $issue_type[$feedback[$i]['category']],
                'updated_date' => $feedback[$i]['updated_at'],
                'created_date' => $feedback[$i]['created_at'],
                'client_message' => $feedback[$i]['client_message'],
                'company_avatar' => $company_avatar,
                'company_id' => $company_id,
                'company_name' => $company_name,
                'company_number' => $company_number,
                'closed_avatar' => $closed_avatar,
                'closed_name' => $closed_name,
                'closed_role' => $role[$closed_role]
            ];
        }

        if($feedback){
            return response()->json([
                'status' => true,
                'message' => 'Feedback',
                'data' => [
                    'profile' => [
                        'id' => $user->id,
                        'user_id' => '#'.$user->user_id,
                        'avatar_img' => $user->avatar_img,
                        'name' => ucwords($user->first_name).' '.ucwords($user->last_name),
                        'email' => $user->email,
                        'days' => $user->plan_day_remain,
                        'access_web' => $user->access_web,
                        'status' => $user->status,
                        'role' => $user->role,
                        'permission' => $user->permission,
                        'companydepartment' => $companydepartment,
                        'created' => strtoupper($user->created_at->format('dS M, l')),
                        'last_modified' => strtoupper($user->updated_at->format('dS M, l'))
                    ],
                    'feedback' => $feedback_list
                ]
            ]);
        }else{
            return response()->json([
                'status' => false,
                'message' => 'Your account data not found',
                'data' => null
            ],401);
        }
    }

    public function view(Request $request){
        $user = auth()->user();

        $id = $request->id;

        $feedback = Feedback::where('id', $id)->get();
        $companydepartment = CompanyDepartment::where('created_by', $user->id)->get()->count();

        if($feedback){
            return response()->json([
                'status' => true,
                    'message' => 'Feedback',
                    'data' => [
                        'profile' => [
                            'id' => $user->id,
                            'user_id' => '#'.$user->user_id,
                            'avatar_img' => $user->avatar_img,
                            'name' => ucwords($user->first_name).' '.ucwords($user->last_name),
                            'email' => $user->email,
                            'days' => $user->plan_day_remain,
                            'access_web' => $user->access_web,
                            'status' => $user->status,
                            'role' => $user->role,
                            'permission' => $user->permission,
                            'companydepartment' => $companydepartment,
                            'created' => strtoupper($user->created_at->format('dS M, l')),
                            'last_modified' => strtoupper($user->updated_at->format('dS M, l'))
                        ],
                        'feedback' => $feedback
                    ]
            ]);
        }else{
            return response()->json([
                'status' => false,
                'message' => 'Your account data not found',
                'data' => null
            ],401);
        }
    }

    public function create(CreateFeedbackRequest $request){
        return $this->service->createFeedback($request->validated());
    }
    public function update(UpdateFeedbackRequest $request){
        return $this->service->updateFeedback($request->validated());
    }
}
