<?php

namespace App\Http\Controllers\Api\Web;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

use App\Models\User;
use App\Models\Category;
use App\Models\CompanyDepartment;

use App\Customs\Services\DepartmentService;
use App\Http\Requests\Dashboard\UpdateDepartmentRequest;
use App\Http\Requests\Dashboard\CreateDepartmentRequest;

class WebDepartmentController extends Controller
{
    public function __construct(private DepartmentService $service){}

    public function list(){
        $user = auth()->user();

        $department = CompanyDepartment::where('created_by', $user->id)->where('plan_status', '!=',3)->get();
        $department_list = [];
        for($ab = 0; $ab < count($department); $ab++){
            $auditor = User::where('role', 3)->where('company_id', $department[$ab]['id'])->where('status', '!=',3)->get();
            $assignees = [];
            for($j = 0; $j < count($auditor); $j++){
                    $assignees[] = [
                        'auditor_id' => $auditor[$j]['user_id'],
                        'auditor_name' => $auditor[$j]['first_name']. ' ' .$auditor[$j]['last_name']
                    ];
            }

            $department_list[] = [
                'id' => $department[$ab]['id'],
                'avatar' => $department[$ab]['logos'],
                'company_name' => $department[$ab]['name'],
                'tags_name' => $department[$ab]['short_name'],
                'action_assignees' => $assignees,
                'last_modified' => $department[$ab]['updated_at'],
                'schedules_default_time_start' => $department[$ab]['schedules_start_time'],
                'schedules_default_time_end' => $department[$ab]['schedules_end_time'],
                'status' => $department[$ab]['plan_status']
            ];
        }

        $companydepartment = CompanyDepartment::where('created_by', $user->id)->get()->count();

        if($department){
            return response()->json([
                'status' => true,
                    'message' => 'Company / Department List',
                    'data' => [
                        'profile' => [
                            'id' => $user->id,
                            'user_id' => '#'.$user->user_id,
                            'avatar_img' => $user->avatar_img,
                            'name' => ucwords($user->first_name).' '.ucwords($user->last_name),
                            'email' => $user->email,
                            'days' => $user->plan_day_remain,
                            'access_web' => $user->access_web,
                            'status' => $user->status,
                            'role' => $user->role,
                            'permission' => $user->permission,
                            'companydepartment' => $companydepartment,
                            'created' => strtoupper($user->created_at->format('dS M, l')),
                            'last_modified' => strtoupper($user->updated_at->format('dS M, l'))
                        ],
                        'department_list' => $department_list,
                        
                    ]
            ]);
        }else{
            return response()->json([
                'status' => false,
                'message' => 'Your account data not found',
                'data' => null
            ],401);
        }
    }
    public function view(Request $request){
        $user = auth()->user();

        $id = $request->id;

        // $category = Category::get();
        $department = CompanyDepartment::where('created_by', $user->id)->where('id', $id)->get();
        $department_list = [];
        for($ab = 0; $ab < count($department); $ab++){
            $department_list[] = [
                'id' => $department[$ab]['id'],
                'avatar' => $department[$ab]['logos'],
                'company_name' => $department[$ab]['name'],
                'tags_name' => $department[$ab]['short_name'],
                'last_modified' => $department[$ab]['updated_by'],
                'schedules_default_time_start' => $department[$ab]['schedules_start_time'],
                'schedules_default_time_end' => $department[$ab]['schedules_end_time'],
                'status' => $department[$ab]['plan_status']
            ];
        }
        $companydepartment = CompanyDepartment::where('created_by', $user->id)->get()->count();

        if($department){
            return response()->json([
                'status' => true,
                    'message' => 'Company / Department Show',
                    'data' => [
                        'profile' => [
                            'id' => $user->id,
                            'user_id' => '#'.$user->user_id,
                            'avatar_img' => $user->avatar_img,
                            'name' => ucwords($user->first_name).' '.ucwords($user->last_name),
                            'email' => $user->email,
                            'days' => $user->plan_day_remain,
                            'access_web' => $user->access_web,
                            'status' => $user->status,
                            'role' => $user->role,
                            'permission' => $user->permission,
                            'companydepartment' => $companydepartment,
                            'created' => strtoupper($user->created_at->format('dS M, l')),
                            'last_modified' => strtoupper($user->updated_at->format('dS M, l'))
                        ],
                        'department' => $department
                    ]
            ]);
        }else{
            return response()->json([
                'status' => false,
                'message' => 'Your account data not found',
                'data' => null
            ],401);
        }
    }
    public function create(CreateDepartmentRequest $request){
        return $this->service->createDepartment($request->validated());
    }
    public function update(UpdateDepartmentRequest $request){
        return $this->service->updateDepartment($request->validated());
    }
      public function delete(Request $request){
        $user = auth()->user();

        $deleteCompany = CompanyDepartment::where('id',$request->id)->update([
            'plan_status' => $request->status,
            'updated_by' => $user->id,
            'updated_at' => now()
        ]);
        
        if($deleteCompany){
            return response()->json([
                'status' => true,
                'message' => 'Company has been deleted.'
            ],200);
        }else{
            return response()->json([
                'status' => false,
                'message' => 'Something went wrong.'
            ],401);
        }
}
}
