<?php

namespace App\Http\Controllers\Api\Web;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

use App\Models\User;
use App\Models\Schedule;
use App\Models\Locations;
use App\Models\CompanyDepartment;
use App\Models\Checklist;
use App\Models\ChecklistQuestion;
use App\Models\Feedback;

class WebDashboardController extends Controller
{
    public function me(){
        $user = auth()->user();
        
        if($user->role == "1"){
            // users
            $pending = User::where('status', 0)->where('role', '!=', 1)->get()->count();
            $active = User::where('status', 2)->where('role', '!=', 1)->get()->count();
            $inactive = User::where('status', 1)->where('role', '!=', 1)->get()->count();
            $companydepartment = CompanyDepartment::where('created_by', $user->id)->get()->count();

            // audit
            $total = Schedule::get()->count();
            $open = Schedule::where('status',1)->get()->count();
            $inprogress = Schedule::where('status',2)->get()->count();
            $overdue = Schedule::where('status',3)->get()->count();
            $completed = Schedule::where('status',4)->get()->count();

            // feedback
            $responsed = Feedback::where('status', 2)->get()->count();
            $not_responsed = Feedback::where('status', 1)->get()->count();

            // subscription
            $trial = User::where('plan_actived', 1)->get()->count();
            $basic = User::where('plan_actived', 2)->get()->count();
            $advance = User::where('plan_actived', 3)->get()->count();

            // checklist
            $checklist = Checklist::where('status', 1)->get();
            $checklistarray = [];
            for($i = 0; $i < count($checklist); $i++){
                $checklistquestion = ChecklistQuestion::where('checklist_id', $checklist[$i]['id'])->get()->count();
                $checklistarray[] = [
                    'id' => $checklist[$i]['id'],
                    'name' => $checklist[$i]['name'],
                    'total_question' => $checklistquestion
                ];
            }

            // invoice
            $invoice = [];

            if($user){
                
                return response()->json([
                    'status' => true,
                    'message' => 'Welcome to Dashboard : '.ucwords($user->first_name).' '.ucwords($user->last_name),
                    'data' => [
                        'profile' => [
                            'id' => $user->id,
                            'user_id' => '#'.$user->user_id,
                            'avatar_img' => $user->avatar_img,
                            'name' => ucwords($user->first_name).' '.ucwords($user->last_name),
                            'email' => $user->email,
                            'days' => $user->plan_day_remain,
                            'plan_actived' => $user->plan_actived,
                            'access_web' => $user->access_web,
                            'status' => $user->status,
                            'role' => $user->role,
                            'permission' => $user->permission,
                            'companydepartment' => $companydepartment,
                            'created' => strtoupper($user->created_at->format('dS M, l')),
                            'last_modified' => strtoupper($user->updated_at->format('dS M, l'))
                        ],
                        'audits' => [
                            'total' => $total,
                            'open' => $open,
                            'inprogress' => $inprogress,
                            'overdue' => $overdue,
                            'completed' => $completed
                        ],
                        'users' => [
                            'pending' => $pending,
                            'active' => $active,
                            'inactive' => $inactive
                        ],
                        'feedback' => [
                            'responsed' => $responsed,
                            'not_responsed' => $not_responsed
                        ],
                        'subscription' => [
                            'trial' => $trial,
                            'basic' => $basic,
                            'advance' => $advance
                        ],
                        'checklist' => $checklistarray,
                        'invoice' => $invoice
                    ]
                ],200);
            }else{
                return response()->json([
                    'status' => false,
                    'message' => 'Your account data not found',
                    'data' => null
                ],401);
            }
        }else{
            // audit
            $total = Schedule::where('created_by',$user->id)->get()->count();
            $open = Schedule::where('status',1)->where('created_by',$user->id)->get()->count();
            $inprogress = Schedule::where('status',2)->where('created_by',$user->id)->get()->count();
            $overdue = Schedule::where('status',3)->where('created_by',$user->id)->get()->count();
            $completed = Schedule::where('status',4)->where('created_by',$user->id)->get()->count();
            $inreview = Schedule::where('status',5)->where('created_by',$user->id)->get()->count();
            $rejected = Schedule::where('status',6)->where('created_by',$user->id)->get()->count();
            $companydepartment = CompanyDepartment::where('created_by', $user->id)->get()->count();
			
            // $CompanyDepartment = CompanyDepartment::where('status',1)->get();
            $auditor = User::where('role', 3)->where('created_by', $user->id)->get();
            $auditor_list = [];
            for($i = 0; $i < count($auditor); $i++){
                $checklistquestion = Schedule::where('auditor_id', $auditor[$i]['id'])->get()->count();
				$total_audit = Schedule::where('auditor_id', $auditor[$i]['id'])->get()->count();
                $auditor_list[] = [
                    'id' => $auditor[$i]['id'],
                    'name' => $auditor[$i]['first_name']. ' ' .$auditor[$i]['last_name'],
                    'total_question' => $total_audit
                ];
            }
            if($user){
                
                return response()->json([
                    'status' => true,
                    'message' => 'Welcome to Dashboard : '.ucwords($user->first_name).' '.ucwords($user->last_name),
                    'data' => [
                        'profile' => [
                            'id' => $user->id,
                            'user_id' => '#'.$user->user_id,
                            'avatar_img' => $user->avatar_img,
                            'name' => ucwords($user->first_name).' '.ucwords($user->last_name),
                            'email' => $user->email,
                            'days' => $user->plan_day_remain,
                            'plan_actived' => $user->plan_actived,
                            'access_web' => $user->access_web,
                            'status' => $user->status,
                            'role' => $user->role,
                            'permission' => $user->permission,
                            'companydepartment' => $companydepartment,
                            'created' => strtoupper($user->created_at->format('dS M, l')),
                            'last_modified' => strtoupper($user->updated_at->format('dS M, l'))
                        ],
                        'audits' => [
                            'total' => $total,
                            'open' => $open,
                            'inprogress' => $inprogress,
                            'overdue' => $overdue,
                            'completed' => $completed,
                            'inreview' => $inreview,
                            'rejected' => $rejected
                        ],
                        'auditor' => $auditor_list
                    ]
                ],200);
            }else{
                return response()->json([
                    'status' => false,
                    'message' => 'Your account data not found',
                    'data' => null
                ],200);
            }
        }
    }
    public function logout()
    {
        $logout = auth()->logout();
        return response()->json([
            'status' => true,
            'message' => 'Your account has successfully logged out.'
        ],200);
    }
}
