<?php

namespace App\Http\Controllers\Api\Web;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

use App\Models\User;
use App\Models\Category;
use App\Models\Checklist;
use App\Models\ChecklistQuestion;
use App\Models\ChecklistSection;
use App\Models\CompanyDepartment;

use App\Customs\Services\ChecklistService;
use App\Http\Requests\Dashboard\CreateChecklistRequest;
use App\Http\Requests\Dashboard\UpdateChecklistRequest;

class WebChecklistController extends Controller
{
    public function __construct(private ChecklistService $service){}

    public function list(){
        $user = auth()->user();

        $companydepartment = CompanyDepartment::where('created_by', $user->id)->get()->count();
        
        if($user->role == "1"){
            $checklist = Checklist::where('status', '!=',3)->get();
        }else{
            $checklist = Checklist::where('created_by', $user->id)->where('status', '!=',3)->get();
        }
        
        
        $checklist_list = [];
        for($i = 0; $i < count($checklist); $i++){
            
            $questions = ChecklistQuestion::where('checklist_id', $checklist[$i]['id'])->where('status', '!=',3)->get();
            $questions_list = [];
            for($a = 0; $a < count($questions); $a++){
                $questions_list[] = [
                    'questions_id' => $questions[$a]['questions_id'],
                    'type' => $questions[$a]['type'],
                    'label' => $questions[$a]['title'],
                    'name' => $questions[$a]['title']
                ];
            }

            $category = Category::where('id', $checklist[$i]['category_id'])->get()->first();

            $checklist_list[] = [
                'id' => $checklist[$i]['id'],
                'template_image' => null,
                'template_id' => $checklist[$i]['checklist_id'],
                'category_id' => $checklist[$i]['category_id'],
                'category' => $category['name'],
                'title' => $checklist[$i]['name'],
                'description' => null,
                'questions' => $questions_list,
                'created_on' => $checklist[$i]['created_at'],
                'updated_on' => $checklist[$i]['updated_at'],
                'status' => $checklist[$i]['status']
            ];
        }

        if($checklist){
            return response()->json([
                'status' => true,
                'message' => 'Checklist',
                'data' => [
                    'profile' => [
                        'id' => $user->id,
                        'user_id' => '#'.$user->user_id,
                        'avatar_img' => $user->avatar_img,
                        'name' => ucwords($user->first_name).' '.ucwords($user->last_name),
                        'email' => $user->email,
                        'days' => $user->plan_day_remain,
                        'access_web' => $user->access_web,
                        'status' => $user->status,
                        'role' => $user->role,
                        'permission' => $user->permission,
                        'companydepartment' => $companydepartment,
                        'created' => strtoupper($user->created_at->format('dS M, l')),
                        'last_modified' => strtoupper($user->updated_at->format('dS M, l'))
                    ],
                    'checklist' => $checklist_list
                ]
            ]);
        }else{
            return response()->json([
                'status' => false,
                'message' => 'Your account data not found',
                'data' => null
            ],401);
        }
    }
    
    public function list_template(){
        $user = auth()->user();

        $companydepartment = CompanyDepartment::where('created_by', $user->id)->get()->count();
        
        $checklist = Checklist::where('created_by', 1)->get();
        $checklist_list = [];
        for($i = 0; $i < count($checklist); $i++){
            
            $questions = ChecklistQuestion::where('checklist_id', $checklist[$i]['id'])->get();
            $questions_list = [];
            for($a = 0; $a < count($questions); $a++){
                $questions_list[] = [
                    'questions_id' => $questions[$a]['questions_id'],
                    'type' => $questions[$a]['type'],
                    'label' => $questions[$a]['title'],
                    'name' => $questions[$a]['title']
                ];
            }

            $category = Category::where('id', $checklist[$i]['category_id'])->get()->first();

            $checklist_list[] = [
                'id' => $checklist[$i]['id'],
                'template_image' => null,
                'template_id' => $checklist[$i]['checklist_id'],
                'category_id' => $checklist[$i]['category_id'],
                'category' => $category['name'],
                'title' => $checklist[$i]['name'],
                'description' => null,
                'questions' => $questions_list,
                'created_on' => $checklist[$i]['created_at'],
                'updated_on' => $checklist[$i]['updated_at'],
                'status' => $checklist[$i]['status']
            ];
        }

        if($checklist){
            return response()->json([
                'status' => true,
                'message' => 'Checklist',
                'data' => [
                    'profile' => [
                        'id' => $user->id,
                        'user_id' => '#'.$user->user_id,
                        'avatar_img' => $user->avatar_img,
                        'name' => ucwords($user->first_name).' '.ucwords($user->last_name),
                        'email' => $user->email,
                        'days' => $user->plan_day_remain,
                        'access_web' => $user->access_web,
                        'status' => $user->status,
                        'role' => $user->role,
                        'permission' => $user->permission,
                        'companydepartment' => $companydepartment,
                        'created' => strtoupper($user->created_at->format('dS M, l')),
                        'last_modified' => strtoupper($user->updated_at->format('dS M, l'))
                    ],
                    'checklist' => $checklist_list
                ]
            ]);
        }else{
            return response()->json([
                'status' => false,
                'message' => 'Your account data not found',
                'data' => null
            ],401);
        }
    }

    public function view(Request $request){
        $user = auth()->user();

        $id = $request->id;

        $checklist = Checklist::where('id', $id)->get();
        $companydepartment = CompanyDepartment::where('created_by', $user->id)->get()->count();

        if($checklist){
            return response()->json([
                'status' => true,
                    'message' => 'Checklist Show',
                    'data' => [
                        'profile' => [
                            'id' => $user->id,
                            'user_id' => '#'.$user->user_id,
                            'avatar_img' => $user->avatar_img,
                            'name' => ucwords($user->first_name).' '.ucwords($user->last_name),
                            'email' => $user->email,
                            'days' => $user->plan_day_remain,
                            'access_web' => $user->access_web,
                            'status' => $user->status,
                            'role' => $user->role,
                            'permission' => $user->permission,
                            'companydepartment' => $companydepartment,
                            'created' => strtoupper($user->created_at->format('dS M, l')),
                            'last_modified' => strtoupper($user->updated_at->format('dS M, l'))
                        ],
                        'checklist' => $checklist
                    ]
            ]);
        }else{
            return response()->json([
                'status' => false,
                'message' => 'Your account data not found',
                'data' => null
            ],401);
        }
    }

    public function create(CreateChecklistRequest $request){
        return $this->service->createChecklist($request->validated());
    }

    public function update(UpdateChecklistRequest $request){
        return $this->service->updateChecklist($request->validated());
    }
}
