<?php

namespace App\Http\Controllers\Api\Web;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

use App\Models\User;
use App\Models\CompanyDepartment;

use App\Customs\Services\AuditorsService;
use App\Http\Requests\Dashboard\UpdateAuditorsRequest;
use App\Http\Requests\Dashboard\CreateAuditorsRequest;

class WebAuditorsController extends Controller
{
    public function __construct(private AuditorsService $service){}

    public function list(){
        $user = auth()->user();

        $auditors = User::where('created_by', $user->id)->where('status', '!=',3)->get();

        $auditorslist = [];
        for($i = 0; $i < count($auditors); $i++){
            $department = CompanyDepartment::where('id', $auditors[$i]['company_id'])->get()->first();
            if(!empty($department)){
                $department_name = $department['name'];
            }else{
                $department_name = null;
            }
            $access_app_s = [
                null => 'No',
                '' => 'No',
                '0' => 'No',
                '1' => 'Yes'
            ];
            $access_web_s = [
                null => 'No',
                '' => 'No',
                '0' => 'No',
                '1' => 'Yes'
            ];
            $auditorslist[] = [
                'id' => $auditors[$i]['id'],
                'user_id' => $auditors[$i]['user_id'],
                'avatar_img' => $auditors[$i]['avatar_img'],
                'full_name' => $auditors[$i]['first_name']. " " . $auditors[$i]['last_name'],
                 'first_name' => $auditors[$i]['first_name'],
                'last_name' => $auditors[$i]['last_name'],
                'email' => $auditors[$i]['email'],
                'email_verified_at' => $auditors[$i]['email_verified_at'],
                'role' => $auditors[$i]['role'],
                'permission' => $auditors[$i]['permission'],
                'mobile_no' => $auditors[$i]['mobile_no'],
                'gender' => $auditors[$i]['gender'],
                'job_title' => $auditors[$i]['job_title'],
                'short_name' => $auditors[$i]['short_name'],
                'time_zone' => $auditors[$i]['time_zone'],
                'access_app' => $access_app_s[$auditors[$i]['access_app']],
                'access_web' => $access_web_s[$auditors[$i]['access_web']],
                'company_id' => $auditors[$i]['company_id'],
                'company_name' => $department_name,
                'plan_day_remain' => $auditors[$i]['plan_day_remain'],
                'plan_actived' => $auditors[$i]['plan_actived'],
                'plan_payment_status' => $auditors[$i]['plan_payment_status'],
                'status' => $auditors[$i]['status'],
                'created_by' => $auditors[$i]['created_by'],
                'updated_by' => $auditors[$i]['updated_by'],
                'deleted_by' => $auditors[$i]['deleted_by'],
                'created_at' => $auditors[$i]['created_at'],
                'updated_at' => $auditors[$i]['updated_at'],
                'deleted_at' => $auditors[$i]['deleted_at']
            ];
        }
        $companydepartment = CompanyDepartment::where('created_by', $user->id)->get()->count();

        if($auditors){
            return response()->json([
                'status' => true,
                    'message' => 'Auditors',
                    'data' => [
                        'profile' => [
                            'id' => $user->id,
                            'user_id' => '#'.$user->user_id,
                            'avatar_img' => $user->avatar_img,
                            'name' => ucwords($user->first_name).' '.ucwords($user->last_name),
                            'email' => $user->email,
                            'days' => $user->plan_day_remain,
                            'access_web' => $user->access_web,
                            'status' => $user->status,
                            'role' => $user->role,
                            'permission' => $user->permission,
                            'companydepartment' => $companydepartment,
                            'created' => strtoupper($user->created_at->format('dS M, l')),
                            'last_modified' => strtoupper($user->updated_at->format('dS M, l'))
                        ],
                        'Auditors' => $auditorslist
                    ]
            ]);
        }else{
            return response()->json([
                'status' => false,
                'message' => 'Your account data not found',
                'data' => null
            ],401);
        }
    }
    public function view(Request $request){
        $user = auth()->user();

        $id = $request->id;

        $auditors = User::where('created_by', $user->id)->where('id', $id)->get();

        $auditorslist = [];
        for($i = 0; $i < count($auditors); $i++){
            $department = CompanyDepartment::where('id', $auditors[$i]['company_id'])->get()->first();
            $access_app_s = [
                null => 'No',
                '' => 'No',
                '0' => 'No',
                '1' => 'Yes'
            ];
            $access_web_s = [
                null => 'No',
                '' => 'No',
                '0' => 'No',
                '1' => 'Yes'
            ];
            $auditorslist[] = [
                'id' => $auditors[$i]['id'],
                'user_id' => $auditors[$i]['user_id'],
                'avatar_img' => $auditors[$i]['avatar_img'],
                'full_name' => $auditors[$i]['first_name']. " " . $auditors[$i]['last_name'],
                 'first_name' => $auditors[$i]['first_name'],
                'last_name' => $auditors[$i]['last_name'],
                'email' => $auditors[$i]['email'],
                'email_verified_at' => $auditors[$i]['email_verified_at'],
                'role' => $auditors[$i]['role'],
                'permission' => $auditors[$i]['permission'],
                'mobile_no' => $auditors[$i]['mobile_no'],
                'gender' => $auditors[$i]['gender'],
                'job_title' => $auditors[$i]['job_title'],
                'short_name' => $auditors[$i]['short_name'],
                'time_zone' => $auditors[$i]['time_zone'],
                'access_app' => $access_app_s[$auditors[$i]['access_app']],
                'access_web' => $access_web_s[$auditors[$i]['access_web']],
                'company_id' => $auditors[$i]['company_id'],
                'company_name' => $department['name'],
                'plan_day_remain' => $auditors[$i]['plan_day_remain'],
                'plan_actived' => $auditors[$i]['plan_actived'],
                'plan_payment_status' => $auditors[$i]['plan_payment_status'],
                'status' => $auditors[$i]['status'],
                'created_by' => $auditors[$i]['created_by'],
                'updated_by' => $auditors[$i]['updated_by'],
                'deleted_by' => $auditors[$i]['deleted_by'],
                'created_at' => $auditors[$i]['created_at'],
                'updated_at' => $auditors[$i]['updated_at'],
                'deleted_at' => $auditors[$i]['deleted_at']
            ];
        }

        $companydepartment = CompanyDepartment::where('created_by', $user->id)->get()->count();

        if($auditors){
            return response()->json([
                'status' => true,
                    'message' => 'Auditors',
                    'data' => [
                        'profile' => [
                            'id' => $user->id,
                            'user_id' => '#'.$user->user_id,
                            'avatar_img' => $user->avatar_img,
                            'name' => ucwords($user->first_name).' '.ucwords($user->last_name),
                            'email' => $user->email,
                            'days' => $user->plan_day_remain,
                            'access_web' => $user->access_web,
                            'status' => $user->status,
                            'role' => $user->role,
                            'permission' => $user->permission,
                            'companydepartment' => $companydepartment,
                            'created' => strtoupper($user->created_at->format('dS M, l')),
                            'last_modified' => strtoupper($user->updated_at->format('dS M, l'))
                        ],
                        'Auditors' => $auditorslist
                    ]
            ]);
        }else{
            return response()->json([
                'status' => false,
                'message' => 'Your account data not found',
                'data' => null
            ],401);
        }
    }
    
    public function create(CreateAuditorsRequest $request){
        return $this->service->createAuditors($request->validated());
    }
    public function update(UpdateAuditorsRequest $request){
        return $this->service->updateAuditors($request->validated());
    }
        public function delete(Request $request){
        // $user = auth()->user();

        $deleteAuditors = User::where('id',$request->id)->update([
            'status' => $request->status,
        ]);
        
        if($deleteAuditors){
            return response()->json([
                'status' => true,
                'message' => 'Auditor has been deleted.'
            ],200);
        }else{
            return response()->json([
                'status' => false,
                'message' => 'Something went wrong.'
            ],401);
        }
    }
}