<?php

namespace App\Http\Controllers\Api\Web;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

use App\Models\User;
use App\Models\CompanyDepartment;

use App\Customs\Services\AdminsService;
use App\Http\Requests\Dashboard\UpdateAdminsRequest;
use App\Http\Requests\Dashboard\CreateAdminsRequest;
use App\Http\Requests\Dashboard\DeleteAdminsRequest;

class WebAdminsController extends Controller
{
    public function __construct(private AdminsService $service){}

    public function list(){
        $user = auth()->user();

        $admins = User::where('id', '!=',1)->where('role',1)->where('status', '!=',3)->get();
        $companydepartment = CompanyDepartment::where('created_by', $user->id)->get()->count();

        $adminslist = [];
        for($i = 0; $i < count($admins); $i++){
            $department = CompanyDepartment::where('id', $admins[$i]['company_id'])->get()->first();
            $access_app_s = [
                null => 'No',
                '' => 'No',
                '0' => 'No',
                '1' => 'Yes'
            ];
            $access_web_s = [
                null => 'No',
                '' => 'No',
                '0' => 'No',
                '1' => 'Yes'
            ];
            $adminslist[] = [
                'id' => $admins[$i]['id'],
                'user_id' => $admins[$i]['user_id'],
                'avatar_img' => $admins[$i]['avatar_img'],
                'full_name' => $admins[$i]['first_name']. " " . $admins[$i]['last_name'],
                'first_name' => $admins[$i]['first_name'],
                'last_name' => $admins[$i]['last_name'],
                'email' => $admins[$i]['email'],
                'email_verified_at' => $admins[$i]['email_verified_at'],
                'role' => $admins[$i]['role'],
                'permission' => $admins[$i]['permission'],
                'mobile_no' => $admins[$i]['mobile_no'],
                'gender' => $admins[$i]['gender'],
                'job_title' => $admins[$i]['job_title'],
                'short_name' => $admins[$i]['short_name'],
                'time_zone' => $admins[$i]['time_zone'],
                'access_app' => $access_app_s[$admins[$i]['access_app']],
                'access_web' => $access_web_s[$admins[$i]['access_web']],
                'company_id' => $admins[$i]['company_id'],
                'company_name' => null,
                'plan_day_remain' => $admins[$i]['plan_day_remain'],
                'plan_actived' => $admins[$i]['plan_actived'],
                'plan_payment_status' => $admins[$i]['plan_payment_status'],
                'status' => $admins[$i]['status'],
                'created_by' => $admins[$i]['created_by'],
                'updated_by' => $admins[$i]['updated_by'],
                'deleted_by' => $admins[$i]['deleted_by'],
                'created_at' => $admins[$i]['created_at'],
                'updated_at' => $admins[$i]['updated_at'],
                'deleted_at' => $admins[$i]['deleted_at']
            ];
        }

        if($admins){
            return response()->json([
                'status' => true,
                    'message' => 'Admins',
                    'data' => [
                        'profile' => [
                            'id' => $user->id,
                            'user_id' => '#'.$user->user_id,
                            'avatar_img' => $user->avatar_img,
                            'name' => ucwords($user->first_name).' '.ucwords($user->last_name),
                            'email' => $user->email,
                            'days' => $user->plan_day_remain,
                            'access_web' => $user->access_web,
                            'status' => $user->status,
                            'role' => $user->role,
                            'permission' => $user->permission,
                            'companydepartment' => $companydepartment,
                            'created' => strtoupper($user->created_at->format('dS M, l')),
                            'last_modified' => strtoupper($user->updated_at->format('dS M, l'))
                        ],
                        'admins' => $adminslist
                    ]
            ]);
        }else{
            return response()->json([
                'status' => false,
                'message' => 'Your account data not found',
                'data' => null
            ],401);
        }
    }

    public function view(Request $request){
        $user = auth()->user();

        $id = $request->id;

        $admins = User::where('id', '!=',1)->where('role',1)->where('id', $id)->get();

        $adminslist = [];
        for($i = 0; $i < count($admins); $i++){
            $department = CompanyDepartment::where('id', $admins[$i]['company_id'])->get()->first();
            $access_app_s = [
                null => 'No',
                '' => 'No',
                '0' => 'No',
                '1' => 'Yes'
            ];
            $access_web_s = [
                null => 'No',
                '' => 'No',
                '0' => 'No',
                '1' => 'Yes'
            ];
            $adminslist[] = [
                'id' => $admins[$i]['id'],
                'user_id' => $admins[$i]['user_id'],
                'avatar_img' => $admins[$i]['avatar_img'],
                'full_name' => $admins[$i]['first_name']. " " . $admins[$i]['last_name'],
                 'first_name' => $admins[$i]['first_name'],
                'last_name' => $admins[$i]['last_name'],
                'email' => $admins[$i]['email'],
                'email_verified_at' => $admins[$i]['email_verified_at'],
                'role' => $admins[$i]['role'],
                'permission' => $admins[$i]['permission'],
                'mobile_no' => $admins[$i]['mobile_no'],
                'gender' => $admins[$i]['gender'],
                'job_title' => $admins[$i]['job_title'],
                'short_name' => $admins[$i]['short_name'],
                'time_zone' => $admins[$i]['time_zone'],
                'access_app' => $access_app_s[$admins[$i]['access_app']],
                'access_web' => $access_web_s[$admins[$i]['access_web']],
                'company_id' => $admins[$i]['company_id'],
                'company_name' => null,
                'plan_day_remain' => $admins[$i]['plan_day_remain'],
                'plan_actived' => $admins[$i]['plan_actived'],
                'plan_payment_status' => $admins[$i]['plan_payment_status'],
                'status' => $admins[$i]['status'],
                'created_by' => $admins[$i]['created_by'],
                'updated_by' => $admins[$i]['updated_by'],
                'deleted_by' => $admins[$i]['deleted_by'],
                'created_at' => $admins[$i]['created_at'],
                'updated_at' => $admins[$i]['updated_at'],
                'deleted_at' => $admins[$i]['deleted_at']
            ];
        }

        $companydepartment = CompanyDepartment::where('created_by', $user->id)->get()->count();

        if($admins){
            return response()->json([
                'status' => true,
                    'message' => 'View Admins',
                    'data' => [
                        'profile' => [
                            'id' => $user->id,
                            'user_id' => '#'.$user->user_id,
                            'avatar_img' => $user->avatar_img,
                            'name' => ucwords($user->first_name).' '.ucwords($user->last_name),
                            'email' => $user->email,
                            'days' => $user->plan_day_remain,
                            'access_web' => $user->access_web,
                            'status' => $user->status,
                            'role' => $user->role,
                            'permission' => $user->permission,
                            'companydepartment' => $companydepartment,
                            'created' => strtoupper($user->created_at->format('dS M, l')),
                            'last_modified' => strtoupper($user->updated_at->format('dS M, l'))
                        ],
                        'admins' => $adminslist
                    ]
            ]);
        }else{
            return response()->json([
                'status' => false,
                'message' => 'Your account data not found',
                'data' => null
            ],401);
        }
    }

    public function create(CreateAdminsRequest $request){
        return $this->service->createAdmins($request->validated());
    }
    public function update(UpdateAdminsRequest $request){
        return $this->service->updateAdmins($request->validated());
    }
    public function delete(DeleteAdminsRequest $request){
        return $this->service->deleteAdmins($request->validated());
    }
}
