<?php

namespace App\Http\Controllers\Api\Web;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

use App\Models\Invoice;
use App\Models\User;
use App\Models\Plans;
use App\Models\Notifications;
use App\Models\CompanyDepartment;

use App\Customs\Services\AccountService;
use App\Http\Requests\Dashboard\UpdateAccountRequest;

class WebAccountsController extends Controller
{
    public function __construct(private AccountService $service){}
    public function list(){
        $user = auth()->user();
        // accounts
        $accounts = User::where('id', $user->id)->get();
        $accountslist = [];
        for($i = 0; $i < count($accounts); $i++){
            if($user->role == 1){
                $plan_actived = null;
                $plan_description = null;
                $invoice_date = null;
            }else{
                $invoice_date = Invoice::where('created_by', $user->id)->orderBy('created_at','DESC')->get()->first();
                $plans = Plans::where('id', $user->plan_actived)->get()->first();

                $plan_actived = $plans['title'];
                $plan_description = $plans['subtitle'];
                $invoice_date = $invoice_date['billing_end_date'];
            }
            
            $accountslist[] = [
                'id' => $accounts[$i]['id'],
                'user_id' => $accounts[$i]['user_id'],
                'avatar_img' => $accounts[$i]['avatar_img'],
                'full_name' => $accounts[$i]['first_name']. " " . $accounts[$i]['last_name'],
                'first_name' => $accounts[$i]['first_name'],
                'last_name' => $accounts[$i]['last_name'],
                'email' => $accounts[$i]['email'],
                'role' => $accounts[$i]['role'],
                'country_code' => $accounts[$i]['country_code'],
                'mobile_no' => $accounts[$i]['mobile_no'],
                'gender' => $accounts[$i]['gender'],
                'plan_day_remain' => $accounts[$i]['plan_day_remain'],
                'plan_actived' => $plan_actived,
                'plan_description' => $plan_description,
                'invoice_date' => $invoice_date,
                'status' => $accounts[$i]['status'],
                'created_at' => $accounts[$i]['created_at'],
                'updated_at' => $accounts[$i]['updated_at']
            ];
        }
        // billing
        $billing = Invoice::where('created_by', $user->id)->where('plan_actived', '!=',1)->get();
        $billinglist = [];
        for($ib = 0; $ib < count($billing); $ib++){
            $paidlist = Invoice::select('plan_amount')->where('plan_paided_status', 1)->where('id', $billing[$ib]['id'])->get()->first();
            $uppaidlist = Invoice::select('plan_amount')->where('plan_paided_status', 0)->where('id', $billing[$ib]['id'])->get()->first();

            if(is_null($paidlist) == true){
                $paidlists = 0;
            }else{
                $paidlists = $paidlist['plan_amount'];
            }
            if(is_null($uppaidlist) == true){
                $uppaidlists = 0;
            }else{
                $uppaidlists = $uppaidlist['plan_amount'];
            }
            $invoice_status_value = [
                '1' => 'Paid',
                '2' => 'Balance',
            ];

            $billinglist[] = [
                'invoice_id' => $billing[$ib]['invoice_id'],
                'issued_date' => $billing[$ib]['plan_issued_date'],
                'company_id' => $billing[$ib]['company_id'],
                'company_name' => $billing[$ib]['company_name'],
                'company_number' => $billing[$ib]['company_number'],
                'total' => $paidlists,
                'avatar_image' => null,
                'invoice_status' => $billing[$ib]['plan_paided_status'],
                'invoice_status_value' => $invoice_status_value[$billing[$ib]['plan_paided_status']],
                'balance' => $uppaidlists,
                'created_at' => $billing[$ib]['created_at'],
                "action" =>  1
            ];
        }
        // notification
        $notification = Notifications::where('user_id', $user->id)->get();
        $notificationlist = [];
        for($in = 0; $in < count($notification); $in++){
            $notificationlist[] = [
                'id' => $notification[$in]['id'],
                'title' => $notification[$in]['title'],
                'content' => $notification[$in]['content'],
                'status' => $notification[$in]['status'],
                'created_at' => $notification[$in]['created_at'],
                'updated_at' => $notification[$in]['updated_at'],
            ];
        }

        $companydepartment = CompanyDepartment::where('created_by', $user->id)->get()->count();

        if($accounts){
            return response()->json([
                'status' => true,
                    'message' => 'Account Details',
                    'data' => [
                        'profile' => [
                            'id' => $user->id,
                            'user_id' => '#'.$user->user_id,
                            'avatar_img' => $user->avatar_img,
                            'name' => ucwords($user->first_name).' '.ucwords($user->last_name),
                            'email' => $user->email,
                            'days' => $user->plan_day_remain,
                            'access_web' => $user->access_web,
                            'status' => $user->status,
                            'role' => $user->role,
                            'permission' => $user->permission,
                            'companydepartment' => $companydepartment,
                            'created' => strtoupper($user->created_at->format('dS M, l')),
                            'last_modified' => strtoupper($user->updated_at->format('dS M, l'))
                        ],
                        'accounts' => $accountslist,
                        'billing' => $billinglist,
                        'notification' => $notificationlist
                    ]
            ]);
        }else{
            return response()->json([
                'status' => false,
                'message' => 'Your account data not found',
                'data' => null
            ],401);
        }
    }
    public function update(UpdateAccountRequest $request){
        return $this->service->updateAccount($request->validated());
    }
}
