<?php 

namespace App\Http\Controllers\Api\Profile;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use App\Models\User;
use Illuminate\Support\Facades\Storage;

class UserProfileController extends Controller
{
    // public function update(Request $request)
    // {
        
            
    //     // Define validation rules
    //     $validator = Validator::make($request->all(), [
    //         'id' => 'required|exists:users,id', // Ensure the user ID exists
    //         'avatar_img' => 'image|mimes:jpeg,jpg,png|max:3072' // max size is 3072 KB (3 MB)
    //     ]);

    //     // Check if validation fails
    //     if ($validator->fails()) {
    //         return response()->json(['errors' => $validator->errors()], 422);
    //     }

    //     // Find the user
    //     $user = User::find($request->id);

    //     // Handle the file upload if present
    //     if ($request->hasFile('avatar_img')) {
    //         $avatarImg = $request->file('avatar_img');
            
    //         // Generate a unique file name using user_id and timestamp
    //         $timestamp = time();
    //         $userId = $user->user_id;
    //         $extension = $avatarImg->getClientOriginalExtension();
    //         $avatarImgName = "{$userId}_{$timestamp}.{$extension}";
            
    //         // Store the image in the 'public/profile' directory
    //         $avatarImgPath = $avatarImg->storeAs('public/profile', $avatarImgName);
            
    //         // Update the user's avatar_img field with the new file path
    //         $user->avatar_img = $avatarImgName;
    //     }

    //     // Save the changes to the user
    //     if ($user->save()) {
    //         return response()->json([
    //             'status' => true,
    //             'message' => 'User profile has been updated.',
    //             'user' => $user
    //         ], 200);
    //     } else {
    //         return response()->json([
    //             'status' => false,
    //             'message' => 'Failed to update user profile.'
    //         ], 500);
    //     }
    // }
    
    public function update(Request $request)
    {
        // Define validation rules
        $validator = Validator::make($request->all(), [
            'id' => 'required|exists:users,id', // Ensure the user ID exists
            'avatar_img' => 'image|mimes:jpeg,jpg,png|max:9072' 
        ]);
    
        // Check if validation fails
        if ($validator->fails()) {
            return response()->json(['errors' => $validator->errors()], 422);
        }
    
        try {
            // Find the user
            $user = User::findOrFail($request->id);
    
            // Handle the file upload if present
            if ($request->hasFile('avatar_img')) {
                $avatarImg = $request->file('avatar_img');
                
                // Generate a unique file name using user_id and timestamp
                $timestamp = time();
                $userId = $user->id; // Assuming 'id' is the primary key in 'users' table
                $extension = $avatarImg->getClientOriginalExtension();
                $avatarImgName = "{$userId}_{$timestamp}.{$extension}";
                
                // Store the image in the 'public/profile' directory
                $avatarImgPath = $avatarImg->storeAs('public/profile', $avatarImgName);
                
                // Update the user's avatar_img field with the new file path
                $user->avatar_img = $avatarImgName;
            }
    
            // Save the changes to the user
            if ($user->save()) {
                return response()->json([
                    'status' => true,
                    'message' => 'User profile has been updated.',
                    'user' => $user
                ], 200);
            } else {
                return response()->json([
                    'status' => false,
                    'message' => 'Failed to update user profile.'
                ], 500);
            }
        } catch (\Exception $e) {
            // Handle unexpected errors
            return response()->json([
                'status' => false,
                'message' => 'An error occurred while updating the profile.',
                'error' => $e->getMessage()
            ], 500);
        }
    }
    
}
