<?php

namespace App\Http\Controllers\Api\Profile;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\User;
use App\Models\Schedule;
use App\Models\Locations;
use App\Models\CompanyDepartment;
use App\Models\Checklist;
use App\Customs\Services\ScheduleService;
use App\Http\Requests\UpdateScheduleRequest;

class ScheduleController extends Controller
{
    public function __construct(private ScheduleService $service){}

    public function list(Request $request){
        $user = auth()->user();

        $status = $request->input('status');

        $from = $request->input('from');
        $to = $request->input('to');
        $signal_date = $request->input('signal_date');

        if($status == null || $status == ''){
            $schedule = [];
        }elseif($status == 0){
            if(($from != null && $to != null) || ($from != '' && $to != '')){
                $schedule = Schedule::where('auditor_id', $user->id)->whereBetween('schedule_on', [date('Y-m-d H:i:s' , strtotime($from)), date('Y-m-d H:i:s' , strtotime($to))])->orderBy('created_at', 'desc')->get();
            }elseif($signal_date != null || $signal_date != ''){
                $schedule = Schedule::where('auditor_id', $user->id)->where('schedule_on', date('Y-m-d H:i:s' , strtotime($signal_date)))->orderBy('created_at', 'desc')->get();
            }else{
                $schedule = Schedule::where('auditor_id', $user->id)->orderBy('created_at', 'desc')->get();
            }
        }else{
            if(($from != null && $to != null) || ($from != '' && $to != '')){
                $schedule = Schedule::where('auditor_id', $user->id)->where('status', $status)->whereBetween('schedule_on', [date('Y-m-d H:i:s' , strtotime($from)), date('Y-m-d H:i:s' , strtotime($to))])->orderBy('created_at', 'desc')->get();
            }elseif($signal_date != null || $signal_date != ''){
                $schedule = Schedule::where('auditor_id', $user->id)->where('status', $status)->where('schedule_on', date('Y-m-d H:i:s' , strtotime($signal_date)))->orderBy('created_at', 'desc')->get();
            }else{
                $schedule = Schedule::where('auditor_id', $user->id)->where('status', $status)->orderBy('created_at', 'desc')->get();
            }
        }

        if(empty(count($schedule))){
            $audit = [];
        }else{
            $audit = [];
            for($i = 0; $i < count($schedule); $i++){
                $user_schedule = User::where('id', $schedule[$i]['auditor_id'])->get()->first();
                $user_location = Locations::where('id', $schedule[$i]['location_id'])->get()->first();
                $user_department = CompanyDepartment::where('id', $schedule[$i]['company_id'])->get()->first();
                $checklist = Checklist::where('id', $schedule[$i]['checklist_id'])->get()->first();
                $reschedule_status = $schedule[$i]['reschedule_status'];
                if(empty($reschedule_status) || $reschedule_status = 0){
                    $schedule_on = $schedule[$i]['schedule_on']->format('dS M, l');
                    $schedule_time = $schedule[$i]['start_time']->format('h:i A').' To '.$schedule[$i]['end_time']->format('h:i A');
                }else{
                    $schedule_on = $schedule[$i]['reschedule_on']->format('dS M, l');
                    $schedule_time = $schedule[$i]['re_start_time']->format('h:i A').' To '.$schedule[$i]['re_end_time']->format('h:i A');
                }
                // $status_number = $schedule[$i]['status'];
                $status = [
                    '1' => 'Open',
                    '2' => 'In Progress',
                    '3' => 'Overdue',
                    '4' => 'Completed'
                ];
                $reschedule = [
                    null => 'No',
                    '' => 'No',
                    '0' => 'No',
                    '1' => 'Yes'
                ];
                $audit[] = [
                    'id' => $schedule[$i]['id'],
                    'schedule_on' => $schedule_on,
                    'status' => $status[$schedule[$i]['status']],
                    'reschedule_status' => $reschedule[$schedule[$i]['reschedule_status']],
                    'schedule_id' => $schedule[$i]['schedule_id'],
                    'checklist_id' => $schedule[$i]['checklist_id'],
                    'checklist_name' => $checklist['name'],
                    'schedule_time' => $schedule_time,
                    'company_id' => $user_department['user_id'],
                    'company_avatar' => $user_department['logos'],
                    'company_name' => $user_department['name'],
                    'location' => $user_location['name'],
                    'auditor_id' => $user_schedule['user_id'],
                    'auditor_avatar' => $user_schedule['avatar_img'],
                    'auditor_name' => ucwords($user_schedule['first_name']).' '.ucwords($user_schedule['last_name']),
                ];
            }
        }
        
        if($user){
            if(sizeof($audit)){
                $audits = $audit;
                return response()->json([
                    'status' => true,
                    'message' => 'Audit Panel',
                    'data' => $audits
                ],200);
            }else{
                $audits = null;
                return response()->json([
                    'status' => false,
                    'message' => 'No Data Found.',
                    'data' => $audits
                ],200);
            }
        }else{
            return response()->json([
                'status' => false,
                'message' => 'Your account data not found',
                'data' => null
            ],200);
        }
    }
    public function update(UpdateScheduleRequest $request){
        return $this->service->updateReschedule($request->validated());
    }
}
