<?php

namespace App\Http\Controllers\Api\Profile;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

use App\Models\Checklist;
use App\Models\Category;
use App\Models\CompanyDepartment;
use App\Models\ChecklistSection;
use App\Models\ChecklistQuestion;

use App\Models\AuditReport;
use App\Models\AuditQuestionReport;
use App\Models\Schedule;

class QuestionController extends Controller
{
    public function list(Request $request){
        $user = auth()->user();

        $checklist = $request->input('checklist_id');
        $schedule_id = $request->input('schedule_id');

        $foldername = Schedule::where('id', $schedule_id)->get()->first();

        if($checklist == null || $checklist == '' || $checklist == 0){
            $checklist = [];
        }else{
            // $checklist = [];
            $checklist = Checklist::where('id', $checklist)->where('status', 1)->get()->first();
        }

        if(empty($checklist)){
            $checklist = [];
        }else{
            $category = Category::where('id', $checklist['category_id'])->get()->first();
            
            $schedule_company = Schedule::where('id', $schedule_id)->get()->first();
            $user_department = CompanyDepartment::where('id', $schedule_company['company_id'])->get()->first();
            
            $checklist_section = ChecklistSection::where('checklist_id', $checklist['id'])->where('status', 1)->get();
            $checklist_question_total = ChecklistQuestion::where('checklist_id', $checklist['id'])->where('status', 1)->get();
            $checklist_question_answer = AuditQuestionReport::where('schedule_id', $schedule_id)->where('checklist_id', $checklist['id'])->where('status', 1)->get();
            
            for($i = 0; $i < count($checklist_section); $i++){
                
                $checklist_question = ChecklistQuestion::where('section_id', '=', $checklist_section[$i]['id'])->where('checklist_id','=', $checklist['id'])->where('status', 1)->get();
                $checklist_answer = AuditQuestionReport::where('section_id', '=', $checklist_section[$i]['id'])->where('schedule_id', $schedule_id)->where('checklist_id', $checklist['id'])->get();

                // $checklist_question->count();
                if(count($checklist_question) == 0){
                    $checklist_questions = null;
                }else{
                    $checklist_questions = [];
                    for($xy = 0; $xy < count($checklist_question); $xy++){
                        $questionanswer = AuditQuestionReport::where('questions_id',$checklist_question[$xy]['id'])->where('section_id', '=', $checklist_section[$i]['id'])->where('schedule_id', $schedule_id)->where('checklist_id', $checklist['id'])->get();
                        // return response()->json($checklist_section[$i]['id']);
                        if(count($questionanswer) != 1){
                            $answers = false;
                            $questionanswers = $checklist_question[$xy]['option_array'];
                            $questions_images = [];
                            $questions_comments = null;
                        }else{
                            $answers = true;
                            $questionanswers = $questionanswer[0]['questions_answer_array'];
                            $questions_images = $questionanswer[0]['questions_image'];
                            $questions_comments = $questionanswer[0]['questions_comment'];
                        }

                        $checklist_questions[] = [
                            'id' => $checklist_question[$xy]['id'],
                            'questions_id' => $checklist_question[$xy]['questions_id'],
                            'title' => $checklist_question[$xy]['title'],
                            'answer' => $answers,
                            'type' => $checklist_question[$xy]['type'],
                            'option_array' => $questionanswers,
                            'questions_image' => $questions_images,
                            'questions_comment' => $questions_comments,
                            'created_at' => $checklist_question[$xy]['created_at'],
                            'updated_at' => $checklist_question[$xy]['updated_at']
                        ];
                    }
                }

                $section[] =[
                    'section_id' => $checklist_section[$i]['section_id'],
                    'section_name' => $checklist_section[$i]['name'],
                    'section_total_question' => $checklist_question->count(),
                    'section_total_answer' => $checklist_answer->count(),
                    'section_question' => $checklist_questions
                ];
            }
            $status = [
                '1' => 'Active',
                '2' => 'Inactive'
            ];
            $checklist = [ 
                'id' => $checklist['id'],
                'schedule_id' => $schedule_id,
                'folder_url' => asset('storage/app/question/'.$foldername['schedule_id']).'/',
                'checklist_id' => $checklist['checklist_id'],
                'checklist_name' => $checklist['name'],
                'category_name' => $category['name'],
                'company_id' => $user_department['user_id'],
                'company_avatar' => $user_department['logos'],
                'company_name' => $user_department['name'],
                'total_section' => $checklist_section->count(),
                'total_question' => $checklist_question_total->count(),
                'total_answer' => $checklist_question_answer->count(),
                'total_point' => '300',
                'total_point_score' => '300',
                'section' => $section,
                'status' => $status[$checklist['status']],
            ];
        }

        if($checklist){
            if(sizeof($checklist)){
                $checklists = $checklist;
                return response()->json([
                    'status' => true,
                    'message' => 'Checklist Panel',
                    'data' => $checklists
                ],200);
            }else{
                $checklists = null;
                return response()->json([
                    'status' => false,
                    'message' => 'No Data Found.',
                    'data' => $checklists
                ],200);
            }
        }else{
            return response()->json([
                'status' => false,
                'message' => 'Your account data not found',
                'data' => null
            ],200);
        }
    }
    // public function store(StoreAnswerRequest $request){}
}
