<?php

namespace App\Http\Controllers\Api\Profile;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Notifications;

use App\Customs\Services\NotificationService;
use App\Http\Requests\UpdateNotificationRequest;

class NotificationController extends Controller
{
    public function __construct(private NotificationService $service){}

    public function list(Request $request){
        $user = auth()->user();
        
        $notifications = Notifications::where('user_id', $user->id)->get();

        if($notifications){
            if(sizeof($notifications)){
                $notification = $notifications;
            }else{
                $notification = null;
            }
            return response()->json([
                'status' => true,
                'message' => 'Notifications',
                'data' => 
                    $notification
            ],200);
        }else{
            return response()->json([
                'status' => false,
                'message' => 'Your account data not found',
                'data' => null
            ],200);
        }
    }
    
    public function show(Request $request){
        $user = auth()->user();
        $id = $request->id;
        
        $notifications = Notifications::where('id', $id)->get();

        if($notifications){
            return response()->json([
                'status' => true,
                'message' => 'View Notifications',
                'data' => 
                    $notifications
            ],200);
        }else{
            return response()->json([
                'status' => false,
                'message' => 'Your account data not found',
                'data' => null
            ],200);
        }
    }

    public function update(UpdateNotificationRequest $request){
        return $this->service->updateNotification($request->validated());
    }
    public function push(PushNotificationRequest $request){
        return $this->service->pushNotification($request->validated());
    }
}
