<?php

namespace App\Http\Controllers\Api\Profile;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\User;
use App\Models\Schedule;
use App\Models\Locations;
use App\Models\CompanyDepartment;
use App\Models\Checklist;

use App\Models\AuditReport;
use App\Models\AuditQuestionReport;

class DashboardController extends Controller
{
    public function userdata(){
        $user = auth()->user();
        $auditlist = Schedule::where('auditor_id', $user->id)->where('status','!=',4)->get();
        $auditcount = $auditlist->count();

        $openlist = Schedule::where('auditor_id', $user->id)->where('status',1)->get();
        $opencount = $openlist->count();

        $inprogresslist = Schedule::where('auditor_id', $user->id)->where('status',2)->get();
        $inprogresscount = $inprogresslist->count();

        $overduelist = Schedule::where('auditor_id', $user->id)->where('status',3)->get();
        $overduecount = $overduelist->count();

        $completelist = Schedule::where('auditor_id', $user->id)->where('status',4)->get();
        $completecount = $completelist->count();

        $schedule = Schedule::where('auditor_id', $user->id)->orderBy('created_at', 'desc')->get();
        
        $recentaudit = [];
        for($i = 0; $i < count($schedule); $i++){
            $user_schedule = User::where('id', $schedule[$i]['auditor_id'])->get()->first();
            $user_location = Locations::where('id', $schedule[$i]['location_id'])->get()->first();
            $user_department = CompanyDepartment::where('id', $schedule[$i]['company_id'])->get()->first();
            $checklist = Checklist::where('id', $schedule[$i]['checklist_id'])->get()->first();
            $reschedule_status = $schedule[$i]['reschedule_status'];
            $audit_report = AuditReport::where('schedule_id', $schedule[$i]['id'])->get()->first();
            if(empty($reschedule_status) || $reschedule_status = 0){
                $schedule_on = $schedule[$i]['schedule_on']->format('dS M, l');
                $schedule_time = $schedule[$i]['start_time']->format('h:i A').' To '.$schedule[$i]['end_time']->format('h:i A');
            }else{
                $schedule_on = $schedule[$i]['reschedule_on']->format('dS M, l');
                $schedule_time = $schedule[$i]['re_start_time']->format('h:i A').' To '.$schedule[$i]['re_end_time']->format('h:i A');
            }
            if(!empty($audit_report['audit_id'])){
                $audit_id = $audit_report['audit_id'];
            }else{
                $audit_id = null;
            }
            $status = [
                '1' => 'Open',
                '2' => 'In Progress',
                '3' => 'Overdue',
                '4' => 'Completed'
            ];
            $reschedule = [
                null => 'No',
                '' => 'No',
                '0' => 'No',
                '1' => 'Yes'
            ];
            $recentaudit[] = [
                'id' => $schedule[$i]['id'],
                'audit_id' => $audit_id,
                'schedule_on' => $schedule_on,
                'status' => $status[$schedule[$i]['status']],
                'reschedule_status' => $reschedule[$schedule[$i]['reschedule_status']],
                'schedule_id' => $schedule[$i]['schedule_id'],
                'checklist_id' => $schedule[$i]['checklist_id'],
                'checklist_name' => $checklist['name'],
                'schedule_time' => $schedule_time,
                'company_id' => $user_department['user_id'],
                'company_avatar' => $user_department['logos'],
                'company_name' => $user_department['name'],
                'location' => $user_location['name'],
                'auditor_id' => $user_schedule['user_id'],
                'auditor_avatar' => $user_schedule['avatar_img'],
                'auditor_name' => ucwords($user_schedule['first_name']).' '.ucwords($user_schedule['last_name']),
                
                // 'total_question' => $schedule[$i]['total_question'],
                // 'total_ques_answered' => $schedule[$i]['total_ques_answered'],  
            ];
        }

        if($user){
            if(sizeof($recentaudit)){
                $recentaudits = $recentaudit;
            }else{
                $recentaudits = null;
            }
            return response()->json([
                'status' => true,
                'message' => 'Welcome to Dashboard : '.ucwords($user->first_name).' '.ucwords($user->last_name),
                'data' => [
                    'profile' => [
                        'id' => $user->id,
                        'user_id' => $user->user_id,
                        'avatar_img' => $user->avatar_img,
                        'name' => ucwords($user->first_name).' '.ucwords($user->last_name),
                        'email' => $user->email,
                        'total_task' => $auditcount,
                        'total_open' => $opencount,
                        'total_inprogress' => $inprogresscount,
                        'total_overdue' => $overduecount,
                        'total_complete' => $completecount,
                        'created' => strtoupper($user->created_at->format('dS M, l')),
                        'last_modified' => strtoupper($user->updated_at->format('dS M, l'))
                    ],
                    'recentaudit' => $recentaudits

                ]
            ],200);
        }else{
            return response()->json([
                'status' => false,
                'message' => 'Your account data not found',
                'data' => null
            ],200);
        }

        // return response()->json($response);
    }
}
