<?php

namespace App\Http\Controllers\Api\Profile;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

use App\Customs\Services\AuditsService;
use App\Http\Requests\UpdateAuditsRequest;
use App\Http\Requests\SignAuditsRequest;

class AuditsController extends Controller
{
    public function __construct(private AuditsService $service){}

    public function update(UpdateAuditsRequest $request){
        return $this->service->updateAudits($request->validated());
    }
    
    public function signature(SignAuditsRequest $request){
        return $this->service->updateSignature($request->validated());
    }
}
